/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import java.util.List;

public abstract class PDPageNode
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Parent = COSName.constant("Parent");
    public static final COSName CN_Type_Pages = COSName.constant("Pages");
    public static final COSName CN_Type_Page = COSName.constant("Page");
    public static final COSName DK_Rotate = COSName.constant("Rotate");
    private PDPageTree cachedParent;
    private CDSRectangle cachedCropBox;

    protected PDPageNode(COSObject cOSObject) {
        super(cOSObject);
    }

    protected abstract void collectAnnotations(List var1);

    @Deprecated
    public void dispose() {
        PDPageTree pDPageTree = this.getParent();
        if (pDPageTree != null) {
            pDPageTree.removeNode(this);
        }
    }

    public abstract int getCount();

    public CDSRectangle getCropBox() {
        if (this.cachedCropBox == null) {
            COSArray cOSArray = this.cosGetFieldInheritable(PDPage.DK_CropBox).asArray();
            this.cachedCropBox = cOSArray == null ? this.getMediaBox() : CDSRectangle.createFromCOS(cOSArray);
        }
        return this.cachedCropBox;
    }

    public PDAnnotation getFirstAnnotation() {
        PDPage pDPage = this.getFirstPage();
        while (pDPage != null) {
            PDAnnotation pDAnnotation = pDPage.getFirstAnnotation();
            if (pDAnnotation != null) {
                return pDAnnotation;
            }
            pDPage = pDPage.getNextPage();
        }
        return null;
    }

    public abstract PDPageNode getFirstNode();

    public abstract PDPage getFirstPage();

    @Override
    public PDObject getGenericParent() {
        return this.getParent();
    }

    public PDAnnotation getLastAnnotation() {
        PDPage pDPage = this.getLastPage();
        while (pDPage != null) {
            PDAnnotation pDAnnotation = pDPage.getLastAnnotation();
            if (pDAnnotation != null) {
                return pDAnnotation;
            }
            pDPage = pDPage.getPreviousPage();
        }
        return null;
    }

    public abstract PDPageNode getLastNode();

    public abstract PDPage getLastPage();

    public CDSRectangle getMediaBox() {
        COSArray cOSArray = this.cosGetFieldInheritable(PDPage.DK_MediaBox).asArray();
        if (cOSArray == null) {
            this.setMediaBox(new CDSRectangle(CDSRectangle.SIZE_A4));
            cOSArray = (COSArray)this.cosGetField(PDPage.DK_MediaBox);
        }
        return CDSRectangle.createFromCOS(cOSArray);
    }

    public PDPageNode getNextNode() {
        PDPageTree pDPageTree = this.getParent();
        if (pDPageTree == null) {
            return null;
        }
        return pDPageTree.getNextNode(this);
    }

    public int getNodeIndex() {
        PDPageTree pDPageTree = this.getParent();
        if (pDPageTree == null) {
            return 0;
        }
        return pDPageTree.getNodeIndex(this);
    }

    public PDPage getPageAt(int n) {
        if (n >= this.getCount()) {
            PDPageNode pDPageNode = this.getNextNode();
            if (pDPageNode == null) {
                return null;
            }
            return pDPageNode.getPageAt(n - this.getCount());
        }
        if (n < 0) {
            PDPageNode pDPageNode = this.getPreviousNode();
            if (pDPageNode == null) {
                return null;
            }
            return pDPageNode.getPageAt(pDPageNode.getCount() + n);
        }
        PDPageNode pDPageNode = this.getFirstNode();
        if (pDPageNode == null) {
            return null;
        }
        return pDPageNode.getPageAt(n);
    }

    public PDPageTree getParent() {
        COSDictionary cOSDictionary;
        if (this.cachedParent == null && (cOSDictionary = this.cosGetField(DK_Parent).asDictionary()) != null) {
            this.cachedParent = (PDPageTree)META.createFromCos(cOSDictionary);
        }
        return this.cachedParent;
    }

    public PDPageNode getPreviousNode() {
        PDPageTree pDPageTree = this.getParent();
        if (pDPageTree == null) {
            return null;
        }
        return pDPageTree.getPreviousNode(this);
    }

    public int getRotate() {
        COSInteger cOSInteger = this.cosGetFieldInheritable(DK_Rotate).asInteger();
        if (cOSInteger == null) {
            return 0;
        }
        return cOSInteger.intValue();
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedParent = null;
        this.cachedCropBox = null;
    }

    public abstract boolean isPage();

    public abstract boolean isValid();

    public void setCropBox(CDSRectangle cDSRectangle) {
        this.setFieldObject(PDPage.DK_CropBox, cDSRectangle);
    }

    @Override
    public void setGenericParent(PDObject pDObject) {
        if (!(pDObject instanceof PDPageTree)) {
            throw new IllegalArgumentException("parent must be a PDPAgeTree");
        }
        this.setParent((PDPageTree)pDObject);
    }

    public void setMediaBox(CDSRectangle cDSRectangle) {
        this.setFieldObject(PDPage.DK_MediaBox, cDSRectangle);
    }

    protected void setParent(PDPageTree pDPageTree) {
        this.setFieldObject(DK_Parent, pDPageTree);
    }

    public void setRotate(int n) {
        COSObject cOSObject;
        COSInteger cOSInteger = COSInteger.create(n);
        if (((Object)cOSInteger).equals(cOSObject = this.cosGetFieldInherited(DK_Rotate))) {
            this.cosSetFieldInheritable(DK_Rotate, null);
        } else if (cOSObject.isNull() && n == 0) {
            this.cosSetFieldInheritable(DK_Rotate, null);
        } else {
            this.cosSetFieldInheritable(DK_Rotate, cOSInteger);
        }
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject cOSObject) {
            COSName cOSName = ((COSDictionary)cOSObject).get(DK_Type).asName();
            if (CN_Type_Pages.equals(cOSName)) {
                return PDPageTree.META;
            }
            return PDPage.META;
        }

        @Override
        public Class getRootClass() {
            return PDPageNode.class;
        }
    }
}

