/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.thumbnails.callables;

import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PDimension;
import org.pdfsam.guiclient.business.IdManager;
import org.pdfsam.guiclient.commons.models.VisualListModel;
import org.pdfsam.guiclient.commons.panels.JVisualPdfPageSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.Rotation;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.guiclient.utils.ImageUtility;
import org.pdfsam.i18n.GettextResource;

public class IcePdfThumbnailCallable
implements Callable<Boolean> {
    private static final Logger log = Logger.getLogger((String)IcePdfThumbnailCallable.class.getPackage().getName());
    private Document pdfDocument;
    private JVisualPdfPageSelectionPanel panel;
    private VisualPageListItem pageItem;
    private long id;

    public IcePdfThumbnailCallable(Document pdfDocument, VisualPageListItem pageItem, JVisualPdfPageSelectionPanel panel, long id) {
        this.pdfDocument = pdfDocument;
        this.panel = panel;
        this.pageItem = pageItem;
        this.id = id;
    }

    @Override
    public Boolean call() {
        Boolean retVal = Boolean.FALSE;
        if (!IdManager.getInstance().isCancelledExecution(this.id)) {
            try {
                int pageNumber = this.pageItem.getPageNumber() - 1;
                PDimension dimensions = this.pdfDocument.getPageDimension(pageNumber, 0.0f);
                double rectHeight = dimensions.getHeight();
                double recWidth = dimensions.getWidth();
                float resizePercentage = (float)this.getResizePercentage(rectHeight, recWidth);
                BufferedImage scaledInstance = (BufferedImage)this.pdfDocument.getPageImage(pageNumber, Configuration.getInstance().isHighQualityThumbnails() ? 2 : 1, 2, 0.0f, resizePercentage);
                this.pageItem.setPaperFormat(recWidth, rectHeight, 72);
                int rotation = (int)this.pdfDocument.getPageTree().getPage(pageNumber, this).getTotalRotation(0.0f);
                if (rotation != 0) {
                    this.pageItem.setOriginalRotation(Rotation.getRotation((int)rotation));
                }
                this.pageItem.setThumbnail(scaledInstance);
                retVal = Boolean.TRUE;
            }
            catch (Throwable t) {
                this.pageItem.setThumbnail(ImageUtility.getErrorImage());
                log.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to generate thumbnail"), t);
            }
            ((VisualListModel)this.panel.getThumbnailList().getModel()).elementChanged(this.pageItem);
        }
        return retVal;
    }

    private double getResizePercentage(double height, double width) {
        double retVal = 0.0;
        retVal = height >= width ? (double)Math.round((double)Configuration.getInstance().getThumbnailSize() / height * 100.0) / 100.0 : (double)Math.round((double)Configuration.getInstance().getThumbnailSize() / width * 100.0) / 100.0;
        return retVal < 1.0 ? retVal : 1.0;
    }
}

