/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.components;

import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.DefaultEditorKit;
import org.pdfsam.guiclient.business.listeners.LogActionListener;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class JLogPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 5285203284602898113L;
    private Configuration config;
    private ActionListener listener;

    public JLogPopupMenu() {
        this(new LogActionListener());
    }

    public JLogPopupMenu(ActionListener listener) {
        this.listener = listener;
        this.init();
    }

    private void init() {
        this.config = Configuration.getInstance();
        JMenuItem menuCopy = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuCopy.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Copy"));
        menuCopy.setIcon(new ImageIcon(this.getClass().getResource("/images/edit-copy.png")));
        this.add(menuCopy);
        JMenuItem menuClear = new JMenuItem();
        menuClear.setActionCommand("clearlog");
        menuClear.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Clear"));
        menuClear.setIcon(new ImageIcon(this.getClass().getResource("/images/edit-clear.png")));
        menuClear.addActionListener(this.listener);
        this.add(menuClear);
        JMenuItem menuSelectAll = new JMenuItem();
        menuSelectAll.setActionCommand("selectalllog");
        menuSelectAll.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Select all"));
        menuSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/images/edit-select-all.png")));
        menuSelectAll.addActionListener(this.listener);
        this.add(menuSelectAll);
        this.addSeparator();
        JMenuItem menuSave = new JMenuItem();
        menuSave.setActionCommand("savelog");
        menuSave.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Save log"));
        menuSave.setIcon(new ImageIcon(this.getClass().getResource("/images/edit-save.png")));
        menuSave.addActionListener(this.listener);
        this.add(menuSave);
    }
}

