/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.panels;

import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.plugins.models.PluginDataModel;
import org.pdfsam.i18n.GettextResource;

public class JTreePanel
extends JScrollPane {
    private static final long serialVersionUID = -53156470256505793L;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode plugsNode;
    private DefaultMutableTreeNode rootNode;

    public JTreePanel(DefaultMutableTreeNode rootNode) {
        this.rootNode = rootNode;
        this.plugsNode = new DefaultMutableTreeNode(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Plugins"));
        this.rootNode.add(this.plugsNode);
        this.treeModel = new DefaultTreeModel(rootNode);
        this.tree = new JTree(this.treeModel);
        this.init();
        this.setViewportView(this.tree);
    }

    private void init() {
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(false);
    }

    public void addToRootNode(PluginDataModel pluginDataModel) {
        this.rootNode.add(new DefaultMutableTreeNode(pluginDataModel));
        this.treeModel.reload();
    }

    public void addToPlugsNode(PluginDataModel pluginDataModel) {
        this.plugsNode.add(new DefaultMutableTreeNode(pluginDataModel));
    }

    public void expand() {
        this.tree.expandPath(new TreePath(this.plugsNode.getPath()));
    }

    public JTree getTree() {
        return this.tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public DefaultMutableTreeNode getPlugsNode() {
        return this.plugsNode;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    public TreePath getPluginNodeTreePath(String className) {
        TreePath retVal = null;
        if (this.plugsNode != null && className != null) {
            Enumeration<TreeNode> plugsEnumeration = this.plugsNode.preorderEnumeration();
            while (plugsEnumeration.hasMoreElements()) {
                PluginDataModel selectedPlug;
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)plugsEnumeration.nextElement();
                if (!(currentNode.getUserObject() instanceof PluginDataModel) || !className.equals((selectedPlug = (PluginDataModel)currentNode.getUserObject()).getClassName())) continue;
                retVal = new TreePath(currentNode.getPath());
                break;
            }
        }
        return retVal;
    }

    public void setSelectedPlugin(String className) {
        TreePath path = this.getPluginNodeTreePath(className);
        if (path != null) {
            this.setSelectionPath(path);
        }
    }

    public String getSelectedPlugin() {
        Object selectedObject;
        String retVal = null;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node != null && node.isLeaf() && (selectedObject = node.getUserObject()) instanceof PluginDataModel) {
            PluginDataModel selectedPlug = (PluginDataModel)selectedObject;
            retVal = selectedPlug.getClassName();
        }
        return retVal;
    }
}

