/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.mix.GUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pdfsam.guiclient.business.listeners.EnterDoClickListener;
import org.pdfsam.guiclient.commons.business.actions.SetOutputPathSelectionTableAction;
import org.pdfsam.guiclient.commons.business.listeners.CompressCheckBoxItemListener;
import org.pdfsam.guiclient.commons.components.CommonComponentsFactory;
import org.pdfsam.guiclient.commons.components.JPdfVersionCombo;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.exceptions.LoadJobException;
import org.pdfsam.guiclient.exceptions.SaveJobException;
import org.pdfsam.guiclient.gui.components.JHelpLabel;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.mix.listeners.RunButtonActionListener;

public class MixMainGUI
extends AbstractPlugablePanel {
    private static final long serialVersionUID = -4353488705164373490L;
    private static final Logger log = Logger.getLogger((String)MixMainGUI.class.getPackage().getName());
    private static final String DEFAULT_OUPUT_NAME = "mixed_document.pdf";
    private SpringLayout destinationPanelLayout;
    private SpringLayout mixOptionsPanelLayout;
    private JPanel destinationPanel = new JPanel();
    private JPdfSelectionPanel selectionPanel = new JPdfSelectionPanel(2, 6);
    private JPanel topPanel = new JPanel();
    private JPanel mixOptionsPanel = new JPanel();
    private JPanel optionsChecksPanel = new JPanel();
    private JPanel optionsFieldsPanel = new JPanel();
    private JPdfVersionCombo versionCombo = new JPdfVersionCombo();
    private final JCheckBox overwriteCheckbox = CommonComponentsFactory.getInstance().createCheckBox(1);
    private final JCheckBox outputCompressedCheck = CommonComponentsFactory.getInstance().createCheckBox(2);
    private final JCheckBox reverseFirstCheckbox = new JCheckBox();
    private final JCheckBox reverseSecondCheckbox = new JCheckBox();
    private JTextField destinationTextField = CommonComponentsFactory.getInstance().createTextField(1);
    private JTextField stepTextField = CommonComponentsFactory.getInstance().createTextField(0);
    private JTextField secondStepTextField = CommonComponentsFactory.getInstance().createTextField(0);
    private JHelpLabel destinationHelpLabel;
    private JHelpLabel optionsHelpLabel;
    private Configuration config;
    private final MixFocusPolicy mixFocusPolicy = new MixFocusPolicy();
    private final JButton runButton = CommonComponentsFactory.getInstance().createButton(1);
    private final JButton browseButton = CommonComponentsFactory.getInstance().createButton(2);
    private final JLabel outputVersionLabel = CommonComponentsFactory.getInstance().createLabel(1);
    private final JLabel stepLabel = new JLabel();
    private final JLabel secondStepLabel = new JLabel();
    private final EnterDoClickListener runEnterkeyListener = new EnterDoClickListener(this.runButton);
    private final EnterDoClickListener browseEnterkeyListener = new EnterDoClickListener(this.browseButton);
    private static final String PLUGIN_AUTHOR = "Andrea Vacondio";
    private static final String PLUGIN_VERSION = "0.2.0";

    public MixMainGUI() {
        this.initialize();
    }

    private void initialize() {
        this.config = Configuration.getInstance();
        this.setPanelIcon("/images/mix.png");
        this.setPreferredSize(new Dimension(500, 580));
        this.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints topConst = new GridBagConstraints();
        topConst.fill = 1;
        topConst.ipady = 5;
        topConst.weightx = 1.0;
        topConst.weighty = 1.0;
        topConst.gridwidth = 3;
        topConst.gridheight = 2;
        topConst.gridx = 0;
        topConst.gridy = 0;
        this.topPanel.add((Component)this.selectionPanel, topConst);
        this.mixOptionsPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Mix options")));
        this.mixOptionsPanelLayout = new SpringLayout();
        this.mixOptionsPanel.setLayout(this.mixOptionsPanelLayout);
        this.mixOptionsPanel.setPreferredSize(new Dimension(200, 110));
        this.mixOptionsPanel.setMinimumSize(new Dimension(160, 105));
        this.optionsChecksPanel.setLayout(new BoxLayout(this.optionsChecksPanel, 2));
        this.optionsChecksPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.reverseFirstCheckbox.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Reverse first document"));
        this.reverseFirstCheckbox.setSelected(false);
        this.optionsChecksPanel.add(this.reverseFirstCheckbox);
        this.optionsChecksPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.reverseSecondCheckbox.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Reverse second document"));
        this.reverseSecondCheckbox.setSelected(true);
        this.optionsChecksPanel.add(this.reverseSecondCheckbox);
        this.mixOptionsPanel.add(this.optionsChecksPanel);
        this.stepTextField.setText(Integer.toString(1));
        this.secondStepTextField.setText(Integer.toString(1));
        GroupLayout optionFieldsLayout = new GroupLayout(this.optionsFieldsPanel);
        this.optionsFieldsPanel.setLayout(optionFieldsLayout);
        optionFieldsLayout.setAutoCreateGaps(true);
        optionFieldsLayout.setHorizontalGroup(optionFieldsLayout.createSequentialGroup().addGroup(optionFieldsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stepLabel).addComponent(this.secondStepLabel)).addGroup(optionFieldsLayout.createParallelGroup().addComponent(this.stepTextField).addComponent(this.secondStepTextField)));
        optionFieldsLayout.setVerticalGroup(optionFieldsLayout.createSequentialGroup().addGroup(optionFieldsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stepLabel).addComponent(this.stepTextField)).addGroup(optionFieldsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.secondStepLabel).addComponent(this.secondStepTextField)));
        this.mixOptionsPanel.add(this.optionsFieldsPanel);
        topConst.fill = 2;
        topConst.weightx = 0.0;
        topConst.weighty = 0.0;
        topConst.gridwidth = 3;
        topConst.gridheight = 1;
        topConst.gridx = 0;
        topConst.gridy = 2;
        this.topPanel.add((Component)this.mixOptionsPanel, topConst);
        this.stepLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Number of pages to switch from the first document to the other"));
        this.secondStepLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Number of pages to switch from the second document to the other"));
        StringBuilder sb = new StringBuilder("<html><body><b>");
        sb.append(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Mix options"));
        sb.append("</b><p>");
        sb.append(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Tick the boxes if you want to reverse the first or the second document (or both)."));
        sb.append("</p><p>");
        sb.append(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the number of pages to switch from the first document to the other one (default is 1)."));
        sb.append("</p><p>");
        sb.append(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the number of pages to switch from the second document to the other one (default is 1)."));
        sb.append("</p></body></html>");
        this.optionsHelpLabel = new JHelpLabel(sb.toString(), true);
        this.mixOptionsPanel.add((Component)this.optionsHelpLabel);
        this.stepTextField.setPreferredSize(new Dimension(45, 20));
        this.secondStepTextField.setPreferredSize(new Dimension(45, 20));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 10, 0);
        this.add(this.topPanel, c);
        this.selectionPanel.addPopupMenuAction((AbstractAction)new SetOutputPathSelectionTableAction(this.selectionPanel, this.destinationTextField, DEFAULT_OUPUT_NAME));
        this.destinationPanelLayout = new SpringLayout();
        this.destinationPanel.setLayout(this.destinationPanelLayout);
        this.destinationPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination output file")));
        this.destinationPanel.setPreferredSize(new Dimension(200, 160));
        this.destinationPanel.setMinimumSize(new Dimension(160, 150));
        c.fill = 2;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add(this.destinationPanel, c);
        this.destinationPanel.add(this.destinationTextField);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File chosenFile;
                JFileChooser fileChooser = SharedJFileChooser.getInstance((SharedJFileChooserType)SharedJFileChooserType.PDF_FILE, (int)0, (String)MixMainGUI.this.destinationTextField.getText());
                if (fileChooser.showOpenDialog(MixMainGUI.this.browseButton.getParent()) == 0 && (chosenFile = fileChooser.getSelectedFile()) != null) {
                    MixMainGUI.this.destinationTextField.setText(chosenFile.getAbsolutePath());
                }
            }
        });
        this.destinationPanel.add(this.browseButton);
        this.destinationPanel.add(this.overwriteCheckbox);
        this.outputCompressedCheck.addItemListener((ItemListener)new CompressCheckBoxItemListener(this.versionCombo));
        this.outputCompressedCheck.setSelected(true);
        this.destinationPanel.add(this.outputCompressedCheck);
        this.destinationPanel.add((Component)this.versionCombo);
        this.destinationPanel.add(this.outputVersionLabel);
        String helpTextDest = "<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination output file") + "</b>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Browse or enter the full path to the destination output file.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want to overwrite the output file if it already exists.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want compressed output files (Pdf version 1.5 or higher).") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the pdf version of the ouput document.") + "</p>" + "</body></html>";
        this.destinationHelpLabel = new JHelpLabel(helpTextDest, true);
        this.destinationPanel.add((Component)this.destinationHelpLabel);
        this.runButton.addActionListener((ActionListener)((Object)new RunButtonActionListener(this)));
        this.runButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Execute pdf alternate mix"));
        this.runButton.setSize(new Dimension(88, 25));
        c.fill = 0;
        c.ipadx = 5;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 26;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(10, 10, 10, 10);
        this.add(this.runButton, c);
        this.destinationTextField.addKeyListener((KeyListener)this.runEnterkeyListener);
        this.runButton.addKeyListener((KeyListener)this.runEnterkeyListener);
        this.browseButton.addKeyListener((KeyListener)this.browseEnterkeyListener);
        this.setLayout();
    }

    private void setLayout() {
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationTextField, -105, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.destinationTextField, 10, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationTextField, 30, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.destinationTextField, 5, "West", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.overwriteCheckbox, 17, "North", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("North", (Component)this.overwriteCheckbox, 5, "South", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("West", (Component)this.overwriteCheckbox, 0, "West", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputCompressedCheck, 17, "North", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputCompressedCheck, 5, "South", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputCompressedCheck, 0, "West", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputVersionLabel, 17, "North", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputVersionLabel, 8, "South", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputVersionLabel, 0, "West", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("South", (Component)this.versionCombo, 0, "South", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.versionCombo, 2, "East", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.browseButton, 25, "North", (Component)this.browseButton);
        this.destinationPanelLayout.putConstraint("East", (Component)this.browseButton, -10, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.browseButton, 0, "North", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("West", (Component)this.browseButton, -88, "East", (Component)this.browseButton);
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationHelpLabel, -1, "South", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationHelpLabel, -1, "East", (Component)this.destinationPanel);
        this.mixOptionsPanelLayout.putConstraint("North", (Component)this.optionsChecksPanel, 0, "North", (Component)this.mixOptionsPanel);
        this.mixOptionsPanelLayout.putConstraint("West", (Component)this.optionsChecksPanel, 5, "West", (Component)this.mixOptionsPanel);
        this.mixOptionsPanelLayout.putConstraint("North", (Component)this.optionsFieldsPanel, 5, "South", (Component)this.optionsChecksPanel);
        this.mixOptionsPanelLayout.putConstraint("West", (Component)this.optionsFieldsPanel, 0, "West", (Component)this.optionsChecksPanel);
        this.mixOptionsPanelLayout.putConstraint("South", (Component)this.optionsHelpLabel, -1, "South", (Component)this.mixOptionsPanel);
        this.mixOptionsPanelLayout.putConstraint("East", (Component)this.optionsHelpLabel, -1, "East", (Component)this.mixOptionsPanel);
    }

    public String getPluginAuthor() {
        return PLUGIN_AUTHOR;
    }

    public String getPluginName() {
        return GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Alternate Mix");
    }

    public String getVersion() {
        return PLUGIN_VERSION;
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.mixFocusPolicy;
    }

    public Node getJobNode(Node arg0, boolean savePasswords) throws SaveJobException {
        try {
            if (arg0 != null) {
                PdfSelectionTableItem[] items = this.selectionPanel.getTableRows();
                if (items != null && items.length > 0) {
                    Element firstNode = ((Element)arg0).addElement("first");
                    firstNode.addAttribute("value", items[0].getInputFile().getAbsolutePath());
                    if (savePasswords) {
                        firstNode.addAttribute("password", items[0].getPassword());
                    }
                    Element secondNode = ((Element)arg0).addElement("second");
                    if (items.length > 1) {
                        secondNode.addAttribute("value", items[1].getInputFile().getAbsolutePath());
                        if (savePasswords) {
                            secondNode.addAttribute("password", items[1].getPassword());
                        }
                    }
                }
                Element fileDestination = ((Element)arg0).addElement("destination");
                fileDestination.addAttribute("value", this.destinationTextField.getText());
                Element stepDestination = ((Element)arg0).addElement("step");
                stepDestination.addAttribute("value", this.stepTextField.getText());
                Element secondStepDestination = ((Element)arg0).addElement("secondstep");
                secondStepDestination.addAttribute("value", this.secondStepTextField.getText());
                Element reverseFirst = ((Element)arg0).addElement("reverse_first");
                reverseFirst.addAttribute("value", this.reverseFirstCheckbox.isSelected() ? TRUE : FALSE);
                Element reverseSecond = ((Element)arg0).addElement("reverse_second");
                reverseSecond.addAttribute("value", this.reverseSecondCheckbox.isSelected() ? TRUE : FALSE);
                Element fileOverwrite = ((Element)arg0).addElement("overwrite");
                fileOverwrite.addAttribute("value", this.overwriteCheckbox.isSelected() ? TRUE : FALSE);
                Element fileCompress = ((Element)arg0).addElement("compressed");
                fileCompress.addAttribute("value", this.outputCompressedCheck.isSelected() ? TRUE : FALSE);
                Element pdfVersion = ((Element)arg0).addElement("pdfversion");
                pdfVersion.addAttribute("value", ((StringItem)this.versionCombo.getSelectedItem()).getId());
            }
            return arg0;
        }
        catch (Exception ex) {
            throw new SaveJobException((Throwable)ex);
        }
    }

    public void loadJobNode(Node arg0) throws LoadJobException {
        try {
            Node pdfVersion;
            Node fileCompressed;
            Node reverseSecond;
            Node reverseFirst;
            Node fileOverwrite;
            Node secondStepDestination;
            Node stepDestination;
            Node fileDestination;
            Node secondNode;
            Node firstNode = arg0.selectSingleNode("first/@value");
            if (firstNode != null && firstNode.getText().length() > 0) {
                Node firstPwd = arg0.selectSingleNode("first/@password");
                this.selectionPanel.getLoader().addFile(new File(firstNode.getText()), firstPwd != null ? firstPwd.getText() : null);
            }
            if ((secondNode = arg0.selectSingleNode("second/@value")) != null && secondNode.getText().length() > 0) {
                Node secondPwd = arg0.selectSingleNode("second/@password");
                this.selectionPanel.getLoader().addFile(new File(secondNode.getText()), secondPwd != null ? secondPwd.getText() : null);
            }
            if ((fileDestination = arg0.selectSingleNode("destination/@value")) != null) {
                this.destinationTextField.setText(fileDestination.getText());
            }
            if ((stepDestination = arg0.selectSingleNode("step/@value")) != null) {
                this.stepTextField.setText(stepDestination.getText());
            }
            if ((secondStepDestination = arg0.selectSingleNode("secondstep/@value")) != null) {
                this.secondStepTextField.setText(secondStepDestination.getText());
            }
            if ((fileOverwrite = arg0.selectSingleNode("overwrite/@value")) != null) {
                this.overwriteCheckbox.setSelected(TRUE.equals(fileOverwrite.getText()));
            }
            if ((reverseFirst = arg0.selectSingleNode("reverse_first/@value")) != null) {
                this.reverseFirstCheckbox.setSelected(TRUE.equals(reverseFirst.getText()));
            }
            if ((reverseSecond = arg0.selectSingleNode("reverse_second/@value")) != null) {
                this.reverseSecondCheckbox.setSelected(TRUE.equals(reverseSecond.getText()));
            }
            if ((fileCompressed = arg0.selectSingleNode("compressed/@value")) != null && TRUE.equals(fileCompressed.getText())) {
                this.outputCompressedCheck.doClick();
            }
            if ((pdfVersion = arg0.selectSingleNode("pdfversion/@value")) != null) {
                for (int i = 0; i < this.versionCombo.getItemCount(); ++i) {
                    if (!((StringItem)this.versionCombo.getItemAt(i)).getId().equals(pdfVersion.getText())) continue;
                    this.versionCombo.setSelectedIndex(i);
                    break;
                }
            }
            log.info((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"AlternateMix section loaded."));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
        }
    }

    public void resetPanel() {
        this.selectionPanel.clearSelectionTable();
        this.versionCombo.resetComponent();
        this.reverseFirstCheckbox.setSelected(false);
        this.reverseSecondCheckbox.setSelected(true);
        this.destinationTextField.setText("");
        this.stepTextField.setText("");
        this.secondStepTextField.setText("");
        this.outputCompressedCheck.setSelected(false);
        this.overwriteCheckbox.setSelected(false);
    }

    public JPdfSelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public JPdfVersionCombo getVersionCombo() {
        return this.versionCombo;
    }

    public JCheckBox getOverwriteCheckbox() {
        return this.overwriteCheckbox;
    }

    public JCheckBox getOutputCompressedCheck() {
        return this.outputCompressedCheck;
    }

    public JCheckBox getReverseFirstCheckbox() {
        return this.reverseFirstCheckbox;
    }

    public JCheckBox getReverseSecondCheckbox() {
        return this.reverseSecondCheckbox;
    }

    public JTextField getDestinationTextField() {
        return this.destinationTextField;
    }

    public JTextField getStepTextField() {
        return this.stepTextField;
    }

    public JTextField getSecondStepTextField() {
        return this.secondStepTextField;
    }

    public class MixFocusPolicy
    extends FocusTraversalPolicy {
        public Component getComponentAfter(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getAddFileButton())) {
                return MixMainGUI.this.selectionPanel.getRemoveFileButton();
            }
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getRemoveFileButton())) {
                return MixMainGUI.this.selectionPanel.getMoveUpButton();
            }
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getMoveUpButton())) {
                return MixMainGUI.this.selectionPanel.getMoveDownButton();
            }
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getMoveDownButton())) {
                return MixMainGUI.this.selectionPanel.getClearButton();
            }
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getClearButton())) {
                return MixMainGUI.this.reverseFirstCheckbox;
            }
            if (aComponent.equals(MixMainGUI.this.reverseFirstCheckbox)) {
                return MixMainGUI.this.reverseSecondCheckbox;
            }
            if (aComponent.equals(MixMainGUI.this.reverseSecondCheckbox)) {
                return MixMainGUI.this.stepTextField;
            }
            if (aComponent.equals(MixMainGUI.this.stepTextField)) {
                return MixMainGUI.this.secondStepTextField;
            }
            if (aComponent.equals(MixMainGUI.this.secondStepTextField)) {
                return MixMainGUI.this.destinationTextField;
            }
            if (aComponent.equals(MixMainGUI.this.destinationTextField)) {
                return MixMainGUI.this.browseButton;
            }
            if (aComponent.equals(MixMainGUI.this.browseButton)) {
                return MixMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(MixMainGUI.this.overwriteCheckbox)) {
                return MixMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(MixMainGUI.this.outputCompressedCheck)) {
                return MixMainGUI.this.versionCombo;
            }
            if (aComponent.equals(MixMainGUI.this.versionCombo)) {
                return MixMainGUI.this.runButton;
            }
            if (aComponent.equals(MixMainGUI.this.runButton)) {
                return MixMainGUI.this.selectionPanel.getAddFileButton();
            }
            return MixMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getComponentBefore(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(MixMainGUI.this.runButton)) {
                return MixMainGUI.this.versionCombo;
            }
            if (aComponent.equals(MixMainGUI.this.versionCombo)) {
                return MixMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(MixMainGUI.this.outputCompressedCheck)) {
                return MixMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(MixMainGUI.this.overwriteCheckbox)) {
                return MixMainGUI.this.browseButton;
            }
            if (aComponent.equals(MixMainGUI.this.browseButton)) {
                return MixMainGUI.this.destinationTextField;
            }
            if (aComponent.equals(MixMainGUI.this.destinationTextField)) {
                return MixMainGUI.this.secondStepTextField;
            }
            if (aComponent.equals(MixMainGUI.this.secondStepTextField)) {
                return MixMainGUI.this.stepTextField;
            }
            if (aComponent.equals(MixMainGUI.this.stepTextField)) {
                return MixMainGUI.this.reverseSecondCheckbox;
            }
            if (aComponent.equals(MixMainGUI.this.reverseSecondCheckbox)) {
                return MixMainGUI.this.reverseFirstCheckbox;
            }
            if (aComponent.equals(MixMainGUI.this.reverseFirstCheckbox)) {
                return MixMainGUI.this.selectionPanel.getClearButton();
            }
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getClearButton())) {
                return MixMainGUI.this.selectionPanel.getMoveDownButton();
            }
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getMoveDownButton())) {
                return MixMainGUI.this.selectionPanel.getMoveUpButton();
            }
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getMoveUpButton())) {
                return MixMainGUI.this.selectionPanel.getRemoveFileButton();
            }
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getRemoveFileButton())) {
                return MixMainGUI.this.selectionPanel.getAddFileButton();
            }
            if (aComponent.equals(MixMainGUI.this.selectionPanel.getAddFileButton())) {
                return MixMainGUI.this.runButton;
            }
            return MixMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getDefaultComponent(Container CycleRootComp) {
            return MixMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getLastComponent(Container CycleRootComp) {
            return MixMainGUI.this.runButton;
        }

        public Component getFirstComponent(Container CycleRootComp) {
            return MixMainGUI.this.selectionPanel.getAddFileButton();
        }
    }
}

