/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.pdf.CompressedObject;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.StandardStructureAttributes;
import org.apache.fop.pdf.StructureHierarchyMember;
import org.apache.fop.pdf.StructureType;
import org.apache.fop.util.LanguageTags;

public class PDFStructElem
extends StructureHierarchyMember
implements StructureTreeElement,
CompressedObject {
    private StructureType structureType;
    protected PDFStructElem parentElement;
    protected List<PDFObject> kids;
    private List<PDFDictionary> attributes;

    public PDFStructElem(PDFObject parent, StructureType structureType) {
        this(parent);
        this.structureType = structureType;
        this.put("S", structureType.getName());
        this.setParent(parent);
    }

    private PDFStructElem(PDFObject parent) {
        if (parent instanceof PDFStructElem) {
            this.parentElement = (PDFStructElem)parent;
        }
    }

    public PDFStructElem getParentStructElem() {
        return this.parentElement;
    }

    public void setParent(PDFObject parent) {
        if (parent != null && parent.hasObjectNumber()) {
            this.put("P", new PDFReference(parent));
        }
    }

    public void addKid(PDFObject kid) {
        if (this.kids == null) {
            this.kids = new ArrayList<PDFObject>();
        }
        this.kids.add(kid);
    }

    public void setMCIDKid(int mcid) {
        this.put("K", mcid);
    }

    public void setPage(PDFPage page) {
        this.put("Pg", page);
    }

    public StructureType getStructureType() {
        return this.structureType;
    }

    private void setLanguage(String language) {
        this.put("Lang", language);
    }

    public void setLanguage(Locale language) {
        this.setLanguage(LanguageTags.toLanguageTag(language));
    }

    public String getLanguage() {
        return (String)this.get("Lang");
    }

    protected void writeDictionary(OutputStream out, StringBuilder textBuffer) throws IOException {
        this.attachKids();
        this.attachAttributes();
        super.writeDictionary(out, textBuffer);
    }

    private void attachAttributes() {
        if (this.attributes != null) {
            if (this.attributes.size() == 1) {
                this.put("A", this.attributes.get(0));
            } else {
                PDFArray array = new PDFArray(this.attributes);
                this.put("A", array);
            }
        }
    }

    protected boolean attachKids() {
        boolean kidsAttached;
        ArrayList<PDFObject> validKids = new ArrayList<PDFObject>();
        if (this.kids != null) {
            for (PDFObject kid : this.kids) {
                if (kid instanceof Placeholder) {
                    if (!((Placeholder)kid).attachKids()) continue;
                    validKids.add(kid);
                    continue;
                }
                validKids.add(kid);
            }
        }
        boolean bl = kidsAttached = !validKids.isEmpty();
        if (kidsAttached) {
            PDFArray array = new PDFArray();
            for (PDFObject ob : validKids) {
                array.add(ob);
            }
            this.put("K", array);
        }
        return kidsAttached;
    }

    public void setTableAttributeColSpan(int colSpan) {
        this.setTableAttributeRowColumnSpan("ColSpan", colSpan);
    }

    public void setTableAttributeRowSpan(int rowSpan) {
        this.setTableAttributeRowColumnSpan("RowSpan", rowSpan);
    }

    private void setTableAttributeRowColumnSpan(String typeSpan, int span) {
        PDFDictionary attribute = new PDFDictionary();
        attribute.put("O", StandardStructureAttributes.Table.NAME);
        attribute.put(typeSpan, span);
        if (this.attributes == null) {
            this.attributes = new ArrayList<PDFDictionary>(2);
        }
        this.attributes.add(attribute);
    }

    public static class Placeholder
    extends PDFStructElem {
        public void outputInline(OutputStream out, StringBuilder textBuffer) throws IOException {
            if (this.kids != null) {
                assert (this.kids.size() > 0);
                for (int i = 0; i < this.kids.size(); ++i) {
                    Object obj;
                    if (i > 0) {
                        textBuffer.append(' ');
                    }
                    if ((obj = this.kids.get(i)) instanceof PDFStructElem) {
                        ((PDFStructElem)obj).setParent(this.parentElement);
                    }
                    this.formatObject(obj, out, textBuffer);
                }
            }
        }

        public Placeholder(PDFObject parent) {
            super(parent);
        }
    }
}

