/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.strategy.immutable;

import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.impl.UnmodifiableIteratorAdapter;
import com.gs.collections.impl.parallel.BatchIterable;
import com.gs.collections.impl.set.immutable.AbstractImmutableSet;
import com.gs.collections.impl.set.strategy.immutable.ImmutableSetWithHashingStrategySerializationProxy;
import com.gs.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import java.io.Serializable;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableUnifiedSetWithHashingStrategy<T>
extends AbstractImmutableSet<T>
implements Serializable,
BatchIterable<T> {
    private static final long serialVersionUID = 1L;
    private final UnifiedSetWithHashingStrategy<T> delegate;

    private ImmutableUnifiedSetWithHashingStrategy(UnifiedSetWithHashingStrategy<T> delegate) {
        this.delegate = delegate;
    }

    public static <T> ImmutableSet<T> newSetWith(HashingStrategy<? super T> hashingStrategy, T ... elements) {
        return new ImmutableUnifiedSetWithHashingStrategy<T>(UnifiedSetWithHashingStrategy.newSetWith(hashingStrategy, elements));
    }

    public static <T> ImmutableSet<T> newSet(HashingStrategy<? super T> hashingStrategy, Iterable<T> iterable) {
        return new ImmutableUnifiedSetWithHashingStrategy<T>(UnifiedSetWithHashingStrategy.newSet(hashingStrategy, iterable));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIteratorAdapter<T>(this.delegate.iterator());
    }

    public T getFirst() {
        return this.delegate.getFirst();
    }

    public T getLast() {
        return this.delegate.getLast();
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.delegate.forEach((Procedure<T>)procedure);
    }

    @Override
    public int getBatchCount(int batchSize) {
        return this.delegate.getBatchCount(batchSize);
    }

    @Override
    public void batchForEach(Procedure<? super T> procedure, int sectionIndex, int sectionCount) {
        this.delegate.batchForEach((Procedure<T>)procedure, sectionIndex, sectionCount);
    }

    private Object writeReplace() {
        return new ImmutableSetWithHashingStrategySerializationProxy<T>(this, this.delegate.hashingStrategy());
    }
}

