/*
 * Decompiled with CFR 0.152.
 */
package reactor.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.reactivestreams.PublisherFactory;
import reactor.core.reactivestreams.SubscriberWithContext;
import reactor.core.support.ReactorFatalException;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;

public final class IO {
    private static final ChannelCloseConsumer channelCloseConsumer = new ChannelCloseConsumer();
    private static final ChannelReadConsumer defaultChannelReadConsumer = new ChannelReadConsumer(Buffer.SMALL_BUFFER_SIZE);

    private IO() {
    }

    public static Publisher<Buffer> read(ReadableByteChannel channel) {
        return IO.read(channel, -1);
    }

    public static Publisher<Buffer> read(final ReadableByteChannel channel, int chunkSize) {
        return PublisherFactory.forEach(chunkSize < 0 ? defaultChannelReadConsumer : new ChannelReadConsumer(chunkSize), new Function<Subscriber<? super Buffer>, ReadableByteChannel>(){

            @Override
            public ReadableByteChannel apply(Subscriber<? super Buffer> subscriber) {
                return channel;
            }
        }, channelCloseConsumer);
    }

    public static Publisher<Buffer> readFile(Path path) {
        return IO.readFile(path.toAbsolutePath().toString(), -1);
    }

    public static Publisher<Buffer> readFile(Path path, int chunkSize) {
        return IO.readFile(path.toAbsolutePath().toString(), chunkSize);
    }

    public static Publisher<Buffer> readFile(String path) {
        return IO.readFile(path, -1);
    }

    public static Publisher<Buffer> readFile(final String path, int chunkSize) {
        return PublisherFactory.forEach(chunkSize < 0 ? defaultChannelReadConsumer : new ChannelReadConsumer(chunkSize), new Function<Subscriber<? super Buffer>, ReadableByteChannel>(){

            @Override
            public ReadableByteChannel apply(Subscriber<? super Buffer> subscriber) {
                try {
                    RandomAccessFile file = new RandomAccessFile(path, "r");
                    return new FileContext(file);
                }
                catch (FileNotFoundException e) {
                    throw ReactorFatalException.create(e);
                }
            }
        }, channelCloseConsumer);
    }

    private static final class ChannelCloseConsumer
    implements Consumer<ReadableByteChannel> {
        private ChannelCloseConsumer() {
        }

        @Override
        public void accept(ReadableByteChannel channel) {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
    }

    private static final class ChannelReadConsumer
    implements Consumer<SubscriberWithContext<Buffer, ReadableByteChannel>> {
        private final int bufferSize;

        public ChannelReadConsumer(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        public void accept(SubscriberWithContext<Buffer, ReadableByteChannel> sub) {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(this.bufferSize);
                int read = sub.context().read(buffer);
                if (read > 0) {
                    buffer.flip();
                    sub.onNext(new Buffer(buffer).limit(read));
                } else {
                    sub.onComplete();
                }
            }
            catch (IOException e) {
                sub.onError(e);
            }
        }
    }

    public static final class FileContext
    implements ReadableByteChannel {
        private final RandomAccessFile file;
        private final ReadableByteChannel channel;

        public FileContext(RandomAccessFile file) {
            this.file = file;
            this.channel = file.getChannel();
        }

        public RandomAccessFile file() {
            return this.file;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.channel.read(dst);
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

