/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.util.TextUtil;

public class ErrorReporter {
    private final SourceUnit sourceUnit;

    public ErrorReporter(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public void error(String msg, Object ... args) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage(String.format(msg, args), (ProcessingUnit)this.sourceUnit));
    }

    public void error(String msg, Throwable cause, Object ... args) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage(String.format(msg, args) + "\n\n" + TextUtil.printStackTrace(cause), (ProcessingUnit)this.sourceUnit));
    }

    public void error(ASTNode node, String msg, Object ... args) {
        this.error(new InvalidSpecCompileException(node, msg, args));
    }

    public void error(int line, int column, String msg, Object ... args) {
        this.error(new InvalidSpecCompileException(line, column, msg, args));
    }

    public void error(InvalidSpecCompileException e) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SyntaxErrorMessage((SyntaxException)e, this.sourceUnit));
    }
}

