/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.api.artifacts.repositories;

import groovy.lang.Closure;
import org.gradle.api.Action;

/**
 * An artifact repository which supports username/password authentication.
 */
public interface AuthenticationSupported {

    /**
     * Returns the credentials used to authenticate to this repository.
     * @return The credentials
     */
    PasswordCredentials getCredentials();

    /**
     * Configure the credentials for this repository using the supplied Closure.
     *
     * <pre autoTested=''>
     * repositories {
     *     maven {
     *         credentials {
     *             username = 'joe'
     *             password = 'secret'
     *         }
     *     }
     * }
     * </pre>
     */
    void credentials(Closure closure);

    /**
     * Configure the credentials for this repository using the supplied action.
     *
     * <pre autoTested=''>
     * repositories {
     *     maven {
     *         credentials {
     *             username = 'joe'
     *             password = 'secret'
     *         }
     *     }
     * }
     * </pre>
     */
    void credentials(Action<? super PasswordCredentials> action);
}
