/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEntry
implements Cloneable {
    private String language;
    private String languagename;
    private String location;
    private String logicalname = "";
    private String description = "";
    private Map<String, String> languagedepprops;

    public ScriptEntry(String language, String languagename, String location) {
        this.language = language;
        this.languagename = languagename;
        this.logicalname = languagename;
        this.location = location;
        this.languagedepprops = new HashMap<String, String>();
    }

    public ScriptEntry(ScriptEntry entry) {
        this.language = entry.language;
        this.languagename = entry.languagename;
        this.logicalname = entry.languagename;
        this.location = entry.location;
        this.languagedepprops = entry.languagedepprops;
        this.description = entry.description;
    }

    public ScriptEntry(String language, String languagename, String location, Map<String, String> languagedepprops) {
        this(language, languagename, location);
        this.languagedepprops = languagedepprops;
    }

    public ScriptEntry(String language, String languagename, String location, Map<String, String> languagedepprops, String description) {
        this(language, languagename, location);
        this.languagedepprops = languagedepprops;
        this.description = description;
    }

    public ScriptEntry(String languagename, String location) {
        this("Java", languagename, location);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(ScriptEntry other) {
        return this.language.equals(other.getLanguage()) && this.languagename.equals(other.getLanguageName()) && this.logicalname.equals(other.getLogicalName()) && this.languagedepprops.equals(other.getLanguageProperties()) && this.location.equals(other.getLocation());
    }

    public Map<String, String> getLanguageProperties() {
        return this.languagedepprops;
    }

    public String getLanguageName() {
        return this.languagename;
    }

    public String getLogicalName() {
        return this.logicalname;
    }

    public void setLogicalName(String name) {
        this.logicalname = name;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "\nLogicalName = " + this.logicalname + "\nLanguageName = " + this.languagename + "\nLocation = " + this.location + "\nLanguaguageProperties = " + this.languagedepprops;
    }
}

