/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.UnsupportedEncodingException;
import org.openoffice.xmerge.converter.palm.Record;

public final class PalmDB {
    public static final int NAME_LENGTH = 32;
    private Record[] records;
    private byte[] bName = null;
    private String sName = null;
    private int creatorID = 0;
    private int typeID = 0;
    private int version = 0;
    private short attribute = 0;

    public PalmDB(int n, int n2, int n3, short s) {
        this.records = new Record[0];
        this.setAttributes(n, n2, n3, s);
    }

    public PalmDB(String string, int n, int n2, int n3, short s, Record[] recordArray) throws UnsupportedEncodingException {
        this(string.getBytes("8859_1"), n, n2, n3, s, recordArray);
    }

    public PalmDB(byte[] byArray, int n, int n2, int n3, short s, Record[] recordArray) throws UnsupportedEncodingException {
        this.store(byArray);
        this.records = new Record[recordArray.length];
        System.arraycopy(recordArray, 0, this.records, 0, recordArray.length);
        this.setAttributes(n, n2, n3, s);
    }

    private void setAttributes(int n, int n2, int n3, short s) {
        this.creatorID = n;
        this.typeID = n2;
        this.version = n3;
        this.attribute = s;
    }

    private void store(byte[] byArray) throws UnsupportedEncodingException {
        int n;
        this.bName = new byte[32];
        int n2 = 31;
        int n3 = byArray.length < n2 ? byArray.length : n2;
        for (n = 0; n < n3 && byArray[n] != 0; ++n) {
            this.bName[n] = byArray[n];
        }
        this.sName = new String(this.bName, 0, n, "8859_1");
    }

    public int getCreatorID() {
        return this.creatorID;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public short getAttribute() {
        return this.attribute;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRecordCount() {
        return this.records.length;
    }

    public Record getRecord(int n) {
        return this.records[n];
    }

    public Record[] getRecords() {
        return this.records;
    }

    public String getPDBNameString() {
        return this.sName;
    }

    public byte[] getPDBNameBytes() {
        return this.bName;
    }

    public boolean equals(Object object) {
        boolean bl;
        block7: {
            bl = false;
            if (object instanceof PalmDB) {
                PalmDB palmDB = (PalmDB)object;
                if (this.sName.equals(palmDB.sName) && this.bName.length == palmDB.bName.length) {
                    int n;
                    for (n = 0; n < this.bName.length; ++n) {
                        if (this.bName[n] == palmDB.bName[n]) {
                            continue;
                        }
                        break block7;
                    }
                    if (this.records.length == palmDB.records.length) {
                        for (n = 0; n < this.records.length; ++n) {
                            if (this.records[n].equals(palmDB.records[n])) {
                                continue;
                            }
                            break block7;
                        }
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }
}

