/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.beanshell.ScriptEditorForBeanShell;
import com.sun.star.script.provider.ScriptErrorRaisedException;
import com.sun.star.script.provider.ScriptExceptionRaisedException;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.uno.Any;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

class ScriptImpl
implements XScript {
    private final ScriptMetaData metaData;
    private final XComponentContext m_xContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    private final XModel m_xModel;
    private final XScriptInvocationContext m_xInvocContext;

    ScriptImpl(XComponentContext xComponentContext, ScriptMetaData scriptMetaData, XModel xModel, XScriptInvocationContext xScriptInvocationContext) throws RuntimeException {
        this.metaData = scriptMetaData;
        this.m_xContext = xComponentContext;
        this.m_xModel = xModel;
        this.m_xInvocContext = xScriptInvocationContext;
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
        }
        catch (Exception exception) {
            throw new RuntimeException((Throwable)exception);
        }
        LogUtils.DEBUG("ScriptImpl [beanshell] script data = " + scriptMetaData);
    }

    public Object invoke(Object[] objectArray, short[][] sArray, Object[][] objectArray2) throws ScriptFrameworkErrorException, InvocationTargetException {
        sArray[0] = new short[0];
        objectArray2[0] = new Object[0];
        ClassLoader classLoader = null;
        URL uRL = null;
        try {
            classLoader = ClassLoaderFactory.getURLClassLoader(this.metaData);
            uRL = this.metaData.getSourceURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ScriptFrameworkErrorException(malformedURLException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 3);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        Interpreter interpreter = new Interpreter();
        interpreter.getNameSpace().clear();
        interpreter.setClassLoader(classLoader);
        try {
            interpreter.set("XSCRIPTCONTEXT", (Object)ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory));
            interpreter.set("ARGUMENTS", (Object)objectArray);
        }
        catch (EvalError evalError) {
            throw new ScriptFrameworkErrorException(evalError.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        try {
            ScriptEditorForBeanShell scriptEditorForBeanShell = ScriptEditorForBeanShell.getEditor(uRL);
            if (scriptEditorForBeanShell != null) {
                Object object = scriptEditorForBeanShell.execute();
                if (object == null) {
                    return new Any(new Type(), null);
                }
                return object;
            }
            this.metaData.loadSource();
            String string = this.metaData.getSource();
            if (string == null || string.length() == 0) {
                throw new ScriptFrameworkErrorException("Failed to read script", null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
            }
            Object object = interpreter.eval(string);
            if (object == null) {
                return new Any(new Type(), null);
            }
            return object;
        }
        catch (ParseException parseException) {
            throw new InvocationTargetException("Beanshell failed to parse " + this.metaData.getLanguageName(), null, (Object)this.processBshException((EvalError)((Object)parseException), this.metaData.getLanguageName()));
        }
        catch (TargetError targetError) {
            throw new InvocationTargetException("Beanshell uncaught exception for " + this.metaData.getLanguageName(), null, (Object)this.processBshException((EvalError)((Object)targetError), this.metaData.getLanguageName()));
        }
        catch (EvalError evalError) {
            throw new InvocationTargetException("Beanshell error for " + this.metaData.getLanguageName(), null, (Object)this.processBshException(evalError, this.metaData.getLanguageName()));
        }
        catch (Exception exception) {
            throw new ScriptFrameworkErrorException("Failed to read script", null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
    }

    private void raiseEditor(int n) {
        try {
            URL uRL = this.metaData.getSourceURL();
            ScriptEditorForBeanShell scriptEditorForBeanShell = ScriptEditorForBeanShell.getEditor(uRL);
            if (scriptEditorForBeanShell == null) {
                scriptEditorForBeanShell = ScriptEditorForBeanShell.getEditor();
                scriptEditorForBeanShell.edit(ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory), this.metaData);
                scriptEditorForBeanShell = ScriptEditorForBeanShell.getEditor(uRL);
            }
            if (scriptEditorForBeanShell != null) {
                scriptEditorForBeanShell.indicateErrorLine(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ScriptErrorRaisedException processBshException(EvalError evalError, String string) {
        LogUtils.DEBUG("Beanshell error RAW message " + evalError.getMessage());
        String string2 = evalError.getMessage();
        int n = string2.lastIndexOf("' :");
        int n2 = evalError.getErrorLineNumber();
        this.raiseEditor(n2);
        if (n > -1) {
            string2 = string2.substring(n + 2);
        }
        if (evalError instanceof TargetError) {
            String string3;
            LogUtils.DEBUG("got instance of  TargetError");
            if (n == -1) {
                string2 = ((TargetError)((Object)evalError)).getTarget().getMessage();
            }
            String string4 = "";
            String string5 = evalError.toString();
            int n3 = string5.indexOf("Target exception:");
            if (n3 > -1) {
                string3 = string5.substring(n3);
                LogUtils.DEBUG("About to parse " + string3);
                StringTokenizer stringTokenizer = new StringTokenizer(string5.substring(n3), ":");
                if (stringTokenizer.countTokens() > 2) {
                    LogUtils.DEBUG("First token = " + stringTokenizer.nextToken());
                    string4 = stringTokenizer.nextToken();
                    LogUtils.DEBUG("wrapped exception = = " + string4);
                }
            }
            string3 = new ScriptExceptionRaisedException(string2);
            ((ScriptExceptionRaisedException)string3).lineNum = n2;
            ((ScriptExceptionRaisedException)string3).scriptName = string;
            ((ScriptExceptionRaisedException)string3).exceptionType = string4;
            ((ScriptExceptionRaisedException)string3).language = "BeanShell";
            LogUtils.DEBUG("UnCaught Exception error: ");
            LogUtils.DEBUG("\tscript: " + string);
            LogUtils.DEBUG("\tline: " + n2);
            LogUtils.DEBUG("\twrapped exception: " + string4);
            LogUtils.DEBUG("\tmessage: " + string2);
            return string3;
        }
        LogUtils.DEBUG("Error or ParseError Exception error: ");
        LogUtils.DEBUG("\tscript: " + string);
        LogUtils.DEBUG("\tline: " + n2);
        LogUtils.DEBUG("\tmessage: " + string2);
        return new ScriptErrorRaisedException(string2, null, string, "BeanShell", n2);
    }
}

