/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.global;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import net.adaptivebox.global.BasicTag;
import net.adaptivebox.global.GlobalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalFile {
    private static int counter = -1;

    public static File createTempDir(String string, String string2) {
        String string3;
        File file = null;
        boolean bl = false;
        do {
            if (counter == -1) {
                counter = new Random().nextInt() & 0xFFFF;
            }
            ++counter;
            if (string == null) {
                throw new NullPointerException();
            }
            if (string.length() >= 3) continue;
            throw new IllegalArgumentException("Prefix string too short");
        } while (!(bl = (file = new File(string3 = string2 == null ? string + counter : GlobalFile.getFileLocation(string2, string + counter))).mkdir()));
        return file;
    }

    public static void addStringToFile(String string, String string2) throws Exception {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
        randomAccessFile.seek(randomAccessFile.length());
        randomAccessFile.writeBytes(string);
        randomAccessFile.close();
    }

    public static Object loadObjectFromFile(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    public static void saveObjectToFile(String string, Object object) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStringToFile(String string, String string2) throws Exception {
        new File(new File(string2).getParent()).mkdirs();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(string2));
            fileOutputStream.write(string.getBytes());
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromFile(String string) throws Exception {
        String string2 = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            string2 = new String(byArray);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return string2;
    }

    public static ArrayList<ArrayList<Double>> getCurveDataFromFile(String string) {
        Object object;
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        }
        catch (Exception exception) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(1);
        ArrayList<Double> arrayList2 = new ArrayList<Double>(1);
        try {
            boolean bl = false;
            block8: while (bufferedReader.ready()) {
                object = new StringTokenizer(bufferedReader.readLine());
                while (!((StringTokenizer)object).hasMoreTokens()) {
                    if (!bufferedReader.ready()) continue block8;
                    object = new StringTokenizer(bufferedReader.readLine());
                }
                String string2 = ((StringTokenizer)object).nextToken();
                if (!bl && !string2.startsWith("@")) continue;
                if (!bl) {
                    bl = true;
                    continue;
                }
                if (string2.startsWith("#") || string2.startsWith("$") || string2.startsWith("/")) continue;
                Double d = null;
                Double d2 = null;
                try {
                    d = Double.valueOf(string2);
                    arrayList.add(d);
                }
                catch (NumberFormatException numberFormatException) {
                    bufferedReader.close();
                    fileInputStream.close();
                    return null;
                }
                string2 = ((StringTokenizer)object).nextToken();
                try {
                    d2 = Double.valueOf(string2);
                    arrayList2.add(d2);
                }
                catch (NumberFormatException numberFormatException) {
                    bufferedReader.close();
                    fileInputStream.close();
                    return null;
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return null;
        }
        object = new ArrayList(2);
        ((ArrayList)object).add(arrayList);
        ((ArrayList)object).add(arrayList2);
        return object;
    }

    public static String getFileLocation(String string, String string2) {
        String string3 = string;
        while (string3.length() > 0 && (string3.endsWith("/") || string3.endsWith("\\"))) {
            string3 = string.substring(0, string.length() - 1);
        }
        return string3 + BasicTag.FILE_SEP_TAG + string2;
    }

    public static String getFileName(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        String string3 = string;
        if (string.endsWith(".")) {
            return string3 + string2;
        }
        return string + "." + string2;
    }

    public static String getFileLocation(String string, String string2, String string3) {
        String string4 = GlobalFile.getFileName(string2, string3);
        return GlobalFile.getFileLocation(string, string4);
    }

    public static void clear(String string) throws Exception {
        File file = new File(string);
        if (file.isFile()) {
            file.delete();
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = GlobalFile.getFileLocation(string, stringArray[i]);
            GlobalFile.clear(string2);
        }
        file.delete();
    }

    public static String getFilePrefix(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    public static String getFileSuffix(String string) {
        String[] stringArray = GlobalString.tokenize(string, ".");
        int n = stringArray.length;
        if (n == 1) {
            return "";
        }
        return stringArray[n - 1];
    }

    public static String createTempImageFile(String string) throws Exception {
        return GlobalFile.createTempImageFile(string, "img", ".inf");
    }

    public static String createTempImageFile(String string, String string2, String string3) throws Exception {
        File file = GlobalFile.createTempFile(string2, string3);
        file.deleteOnExit();
        GlobalFile.copyFile(file.getAbsolutePath(), string);
        return file.getAbsolutePath();
    }

    public static void copyFile(String string, String string2) throws Exception {
        String string3 = GlobalFile.getStringFromFile(string2);
        GlobalFile.saveStringToFile(string3, string);
    }

    public static File createTempFile(String string, String string2) throws Exception {
        String string3 = string2;
        if (!string3.startsWith(".")) {
            string3 = "." + string2;
        }
        return File.createTempFile(string, string3);
    }
}

