/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildableModuleVersionListingResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableModuleVersionListingResolveResult {
    private BuildableModuleVersionListingResolveResult.State state = BuildableModuleVersionListingResolveResult.State.Unknown;
    private ModuleVersionResolveException failure;
    private Set<String> versions;
    private boolean authoritative;

    private void reset(BuildableModuleVersionListingResolveResult.State state) {
        this.state = state;
        this.versions = null;
        this.failure = null;
        this.authoritative = false;
    }

    @Override
    public BuildableModuleVersionListingResolveResult.State getState() {
        return this.state;
    }

    @Override
    public boolean hasResult() {
        return this.state != BuildableModuleVersionListingResolveResult.State.Unknown;
    }

    @Override
    public Set<String> getVersions() throws ModuleVersionResolveException {
        this.assertHasResult();
        return this.versions;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    @Override
    public void listed(Collection<String> versions) {
        this.reset(BuildableModuleVersionListingResolveResult.State.Listed);
        this.versions = new LinkedHashSet<String>(versions);
        this.authoritative = true;
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.reset(BuildableModuleVersionListingResolveResult.State.Failed);
        this.failure = failure;
        this.authoritative = true;
    }

    @Override
    public boolean isAuthoritative() {
        this.assertHasResult();
        return this.authoritative;
    }

    @Override
    public void setAuthoritative(boolean authoritative) {
        this.assertHasResult();
        this.authoritative = authoritative;
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

