/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.IOException;
import java.io.Writer;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStore;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.tasks.testing.TestOutputEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryTestResultsProvider
implements TestResultsProvider {
    private final Iterable<TestClassResult> results;
    private final TestOutputStore.Reader outputReader;

    public InMemoryTestResultsProvider(Iterable<TestClassResult> results, TestOutputStore.Reader outputReader) {
        this.results = results;
        this.outputReader = outputReader;
    }

    @Override
    public boolean hasOutput(long id, TestOutputEvent.Destination destination) {
        return this.outputReader.hasOutput(id, destination);
    }

    @Override
    public void writeAllOutput(long id, TestOutputEvent.Destination destination, Writer writer) {
        this.outputReader.writeAllOutput(id, destination, writer);
    }

    @Override
    public void writeNonTestOutput(long id, TestOutputEvent.Destination destination, Writer writer) {
        this.outputReader.writeNonTestOutput(id, destination, writer);
    }

    @Override
    public void writeTestOutput(long classId, long testId, TestOutputEvent.Destination destination, Writer writer) {
        this.outputReader.writeTestOutput(classId, testId, destination, writer);
    }

    @Override
    public void visitClasses(Action<? super TestClassResult> visitor) {
        for (TestClassResult result : this.results) {
            visitor.execute((Object)result);
        }
    }

    @Override
    public boolean isHasResults() {
        return this.results.iterator().hasNext();
    }

    @Override
    public void close() throws IOException {
        this.outputReader.close();
    }
}

