/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.lang.annotation.Annotation;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.specs.Spec;
import org.gradle.internal.BiAction;
import org.gradle.model.internal.core.ExtractedModelRegistration;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelRuleExecutionException;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractModelCreationRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractUnmanagedModelCreationRuleExtractor<T extends Annotation>
extends AbstractModelCreationRuleExtractor<T> {
    @Override
    public Spec<MethodRuleDefinition<?, ?>> getSpec() {
        final Spec<MethodRuleDefinition<?, ?>> superSpec = super.getSpec();
        return new Spec<MethodRuleDefinition<?, ?>>(){

            public boolean isSatisfiedBy(MethodRuleDefinition<?, ?> element) {
                return superSpec.isSatisfiedBy(element) && !element.getReturnType().equals(ModelType.of(Void.TYPE));
            }
        };
    }

    @Override
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition) {
        String modelName = this.determineModelName(ruleDefinition);
        ModelType<R> returnType = ruleDefinition.getReturnType();
        List<ModelReference<?>> references = ruleDefinition.getReferences();
        ModelRuleDescriptor descriptor = ruleDefinition.getDescriptor();
        ModelRuleInvokerBackedTransformer transformer = new ModelRuleInvokerBackedTransformer(returnType, ruleDefinition.getRuleInvoker(), descriptor);
        ModelRegistrations.Builder builder = ModelRegistrations.of(ModelPath.path(modelName), references, transformer).withProjection(new UnmanagedModelProjection<R>(returnType, true, true)).descriptor(descriptor);
        ModelRegistration modelRegistration = this.buildRegistration(builder);
        return new ExtractedModelRegistration(modelRegistration);
    }

    protected abstract ModelRegistration buildRegistration(ModelRegistrations.Builder var1);

    @Override
    public String getDescription() {
        return String.format("%s and returning a model element", super.getDescription());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelRuleInvokerBackedTransformer<T>
    implements BiAction<MutableModelNode, List<ModelView<?>>> {
        private final ModelType<T> type;
        private final ModelRuleDescriptor descriptor;
        private final ModelRuleInvoker<T> ruleInvoker;

        private ModelRuleInvokerBackedTransformer(ModelType<T> type, ModelRuleInvoker<T> ruleInvoker, ModelRuleDescriptor descriptor) {
            this.type = type;
            this.descriptor = descriptor;
            this.ruleInvoker = ruleInvoker;
        }

        public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
            T instance;
            if (inputs.size() == 0) {
                instance = this.ruleInvoker.invoke(new Object[0]);
            } else {
                Object[] args = new Object[inputs.size()];
                for (int i = 0; i < inputs.size(); ++i) {
                    args[i] = inputs.get(i).getInstance();
                }
                instance = this.ruleInvoker.invoke(args);
            }
            if (instance == null) {
                throw new ModelRuleExecutionException(this.descriptor, "rule returned null");
            }
            modelNode.setPrivateData(this.type, instance);
        }
    }
}

