

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Garmin MapSource - txt (tab delimited) (garmin_txt){/block}
  {block name=body}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Garmin MapSource - txt (tab delimited) (garmin_txt)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_mapsource.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_pcx.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_garmin_txt"></a>Garmin MapSource - txt (tab delimited) (garmin_txt)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read and write waypoints
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write tracks
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write routes
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_garmin_txt.html#fmt_garmin_txt_o_date" title="date option">date</a>, <a class="link" href="fmt_garmin_txt.html#fmt_garmin_txt_o_datum" title="datum option">datum</a>, <a class="link" href="fmt_garmin_txt.html#fmt_garmin_txt_o_dist" title="dist option">dist</a>, <a class="link" href="fmt_garmin_txt.html#fmt_garmin_txt_o_grid" title="grid option">grid</a>, <a class="link" href="fmt_garmin_txt.html#fmt_garmin_txt_o_prec" title="prec option">prec</a>, <a class="link" href="fmt_garmin_txt.html#fmt_garmin_txt_o_temp" title="temp option">temp</a>, <a class="link" href="fmt_garmin_txt.html#fmt_garmin_txt_o_time" title="time option">time</a>, <a class="link" href="fmt_garmin_txt.html#fmt_garmin_txt_o_utc" title="utc option">utc</a> .</p><p>
This is a textual format that contains nearly all of the information 
contained in the <span class="productname">MapSource</span>™ main format, <a class="link" href="fmt_gdb.html" title="Garmin MapSource - gdb (gdb)">GDB</a>.
This format also contains some computed values such as distances between 
routepoints and trackpoints, speed, and course (heading).
</p><p>
The main goal of garmin_txt is to make aviation data more available. Because 
<span class="productname">MapSource</span>™ supports only the export, GPSBabel gives you the possibility to 
bring aviation data into <span class="productname">MapSource</span>™.
</p><p>
During the export with <span class="productname">MapSource</span>™, some fields are written using local settings
of <span class="productname">MapSource</span>™ and Windows. These include grid format, gps datum, distance and
temperature units, and the representation of date and time fields. GPSBabel 
tries to read all items automatically. Problems with date and time format can 
be solved with the 'date' and 'time' options.
</p><div class="example"><a id="all_garmin_txt_options"></a><p class="title"><strong>Example 3.8. Command showing garmin_txt output with all options</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i garmin_txt,date="MM/DD/YYYY",time="hh:mm:ss xx" -f in.txt -o garmin_txt,date="DD.MM.YYYY",datum="WGS 72",dist=m,prec=6,temp=c,time="HH:mm:ss",utc=+2 -F out.txt</code></strong></p></div></div><br class="example-break" /><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_txt_o_date"></a><code class="option">date</code> option</h3></div></div></div><p>
      Read/Write date format (i.e. yyyy/mm/dd).
    </p><p>
This option specifies the input and output format for the date.  The format 
is written similarly to those in Windows.  An example format is "YYYY/MM/DD".
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_txt_o_datum"></a><code class="option">datum</code> option</h3></div></div></div><p>
      GPS datum (def. WGS 84).
    </p><p>
This option specifies the datum to be used on output.  Valid values for this 
option are listed in <a class="xref" href="Datums.html" title="Appendix A. Supported Datums">Appendix A, <em>Supported Datums</em></a>.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_txt_o_dist"></a><code class="option">dist</code> option</h3></div></div></div><p>
      Distance unit [m=metric, s=statute].
    </p><p>
This option specifies the unit to be used when outputting distance
values.  Valid values are M for metric (m/km/kph) or S for statute
(ft/mi/mph).
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_txt_o_grid"></a><code class="option">grid</code> option</h3></div></div></div><p>
      Write position using this grid..
    </p><p>
  This value specifies the grid to be used on write.
</p><div class="table"><a id="garmin_grid"></a><p class="title"><strong>Table 3.1. Grid values for garmin_txt</strong></p><div class="table-contents"><table summary="Grid values for garmin_txt" border="1"><colgroup><col /><col /><col /><col /></colgroup><thead><tr><th># idx</th><th>short</th><th>file-header</th><th>sample</th></tr></thead><tbody><tr><td>0</td><td>ddd</td><td>Lat/Lon hddd.ddddd</td><td>    S26.25333 E27.92333</td></tr><tr><td>1</td><td>dmm</td><td>Lat/Lon hddd°mm.mm</td><td>N33 56.539 W118 24.471</td></tr><tr><td>2</td><td>dms</td><td>Lat/Lon hddd°mm'ss.s</td><td>S25 25 26.8 E28 06 07.3</td></tr><tr><td>3</td><td>bng</td><td>British National Grid</td><td>TQ 18919 69392</td></tr><tr><td>4</td><td>utm</td><td>Universal Transverse Mercator</td><td>33 U 318293 5637154</td></tr><tr><td>5</td><td>swiss</td><td>Swiss grid</td><td>776519 167359</td></tr></tbody></table></div></div><br class="table-break" /><p>
  Idx or short are valid params for this option.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_txt_o_prec"></a><code class="option">prec</code> option</h3></div></div></div><p>
      Precision of coordinates.
    </p><p>
This option specifies the precision to be used when writing coordinate values.
Precision is the number of digits after the decimal point.  The default
precision is 3.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_txt_o_temp"></a><code class="option">temp</code> option</h3></div></div></div><p>
      Temperature unit [c=Celsius, f=Fahrenheit].
    </p><p>
This option specifies the unit to be used when writing temperature values.
Valid values are C for Celsius or F for Fahrenheit.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_txt_o_time"></a><code class="option">time</code> option</h3></div></div></div><p>
      Read/Write time format (i.e. HH:mm:ss xx).
    </p><p>
This option specifies the input and output format for the time.  The format 
is written similarly to those in Windows.  An example format is "hh:mm:ss xx".
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_txt_o_utc"></a><code class="option">utc</code> option</h3></div></div></div><p>
      Write timestamps with offset x to UTC time.
    </p><p>
This option specifies the local time zone to use when writing times.  It
is specified as an offset from Universal Coordinated Time (UTC) in hours.  
Valid values are from -23 to +23.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_mapsource.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_pcx.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Garmin MapSource - mps (mapsource) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Garmin PCX5 (pcx)</td></tr></table></div>
  
      {/block}
  