/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.InstrumentationNode;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.SimpleInstrumentListener;
import com.oracle.truffle.api.instrument.SpliceInstrumentListener;
import com.oracle.truffle.api.instrument.SplicedNode;
import com.oracle.truffle.api.instrument.StandardInstrumentListener;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;

public abstract class Instrument {
    private boolean isDisposed = false;
    protected Probe probe = null;
    private final String instrumentInfo;

    public static Instrument create(SimpleInstrumentListener listener, String instrumentInfo) {
        return new SimpleInstrument(listener, instrumentInfo);
    }

    public static Instrument create(StandardInstrumentListener standardListener, String instrumentInfo) {
        return new StandardInstrument(standardListener, instrumentInfo);
    }

    public static Instrument create(SpliceInstrumentListener spliceListener, String instrumentInfo) {
        return new SpliceInstrument(spliceListener, instrumentInfo);
    }

    public static Instrument create(TruffleOptListener listener) {
        return new TruffleOptInstrument(listener, null);
    }

    private Instrument(String instrumentInfo) {
        this.instrumentInfo = instrumentInfo;
    }

    public void dispose() throws IllegalStateException {
        if (this.isDisposed) {
            throw new IllegalStateException("Attempt to dispose an already disposed Instrumennt");
        }
        if (this.probe != null) {
            this.probe.disposeInstrument(this);
        }
        this.isDisposed = true;
    }

    Probe getProbe() {
        return this.probe;
    }

    void setAttachedTo(Probe probe) {
        this.probe = probe;
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    abstract AbstractInstrumentNode addToChain(AbstractInstrumentNode var1);

    abstract AbstractInstrumentNode removeFromChain(AbstractInstrumentNode var1);

    /* synthetic */ Instrument(String string, Instrument instrument) {
        this(string);
    }

    @NodeInfo(cost=NodeCost.NONE)
    abstract class AbstractInstrumentNode
    extends Node
    implements InstrumentationNode.TruffleEvents,
    InstrumentationNode {
        @Node.Child
        protected AbstractInstrumentNode nextInstrumentNode;

        protected AbstractInstrumentNode(AbstractInstrumentNode nextNode) {
            this.nextInstrumentNode = nextNode;
        }

        @Override
        public boolean isInstrumentable() {
            return false;
        }

        private Instrument getInstrument() {
            return Instrument.this;
        }

        private boolean removeFromChain(Instrument instrument) {
            assert (this.getInstrument() != instrument);
            if (this.nextInstrumentNode == null) {
                return false;
            }
            if (this.nextInstrumentNode.getInstrument() == instrument) {
                if (this.nextInstrumentNode.nextInstrumentNode == null) {
                    this.nextInstrumentNode = null;
                } else {
                    this.nextInstrumentNode.replace(this.nextInstrumentNode.nextInstrumentNode);
                }
                return true;
            }
            return this.nextInstrumentNode.removeFromChain(instrument);
        }

        protected String getInstrumentInfo() {
            return Instrument.this.instrumentInfo;
        }
    }

    private static final class SimpleInstrument
    extends Instrument {
        private final SimpleInstrumentListener simpleListener;

        private SimpleInstrument(SimpleInstrumentListener simpleListener, String instrumentInfo) {
            super(instrumentInfo, null);
            this.simpleListener = simpleListener;
        }

        @Override
        AbstractInstrumentNode addToChain(AbstractInstrumentNode nextNode) {
            return new SimpleInstrumentNode(nextNode);
        }

        @Override
        AbstractInstrumentNode removeFromChain(AbstractInstrumentNode instrumentNode) {
            boolean found = false;
            if (instrumentNode != null) {
                if (instrumentNode.getInstrument() == this) {
                    return instrumentNode.nextInstrumentNode;
                }
                found = instrumentNode.removeFromChain(this);
            }
            if (!found) {
                throw new IllegalStateException("Couldn't find instrument node to remove: " + this);
            }
            return instrumentNode;
        }

        @NodeInfo(cost=NodeCost.NONE)
        private final class SimpleInstrumentNode
        extends AbstractInstrumentNode {
            private SimpleInstrumentNode(AbstractInstrumentNode nextNode) {
                super(nextNode);
            }

            @Override
            public void enter(Node node, VirtualFrame vFrame) {
                SimpleInstrument.this.simpleListener.enter(SimpleInstrument.this.probe);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.enter(node, vFrame);
                }
            }

            @Override
            public void returnVoid(Node node, VirtualFrame vFrame) {
                SimpleInstrument.this.simpleListener.returnVoid(SimpleInstrument.this.probe);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnVoid(node, vFrame);
                }
            }

            @Override
            public void returnValue(Node node, VirtualFrame vFrame, Object result) {
                SimpleInstrument.this.simpleListener.returnValue(SimpleInstrument.this.probe, result);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnValue(node, vFrame, result);
                }
            }

            @Override
            public void returnExceptional(Node node, VirtualFrame vFrame, Exception exception) {
                SimpleInstrument.this.simpleListener.returnExceptional(SimpleInstrument.this.probe, exception);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnExceptional(node, vFrame, exception);
                }
            }

            @Override
            public String instrumentationInfo() {
                String info = this.getInstrumentInfo();
                return info != null ? info : SimpleInstrument.this.simpleListener.getClass().getSimpleName();
            }
        }
    }

    private static final class SpliceInstrument
    extends Instrument {
        private final SpliceInstrumentListener spliceListener;

        private SpliceInstrument(SpliceInstrumentListener spliceListener, String instrumentInfo) {
            super(instrumentInfo, null);
            this.spliceListener = spliceListener;
        }

        @Override
        AbstractInstrumentNode addToChain(AbstractInstrumentNode nextNode) {
            return new SpliceInstrumentNode(nextNode);
        }

        @Override
        AbstractInstrumentNode removeFromChain(AbstractInstrumentNode instrumentNode) {
            boolean found = false;
            if (instrumentNode != null) {
                if (instrumentNode.getInstrument() == this) {
                    return instrumentNode.nextInstrumentNode;
                }
                found = instrumentNode.removeFromChain(this);
            }
            if (!found) {
                throw new IllegalStateException("Couldn't find instrument node to remove: " + this);
            }
            return instrumentNode;
        }

        @NodeInfo(cost=NodeCost.NONE)
        private final class SpliceInstrumentNode
        extends AbstractInstrumentNode {
            @Node.Child
            SplicedNode splicedNode;

            private SpliceInstrumentNode(AbstractInstrumentNode nextNode) {
                super(nextNode);
            }

            @Override
            public void enter(Node node, VirtualFrame vFrame) {
                SplicedNode newSplicedNode;
                if (this.splicedNode == null && (newSplicedNode = SpliceInstrument.this.spliceListener.getSpliceNode(SpliceInstrument.this.probe)) != null) {
                    this.splicedNode = newSplicedNode;
                    this.adoptChildren();
                    SpliceInstrument.this.probe.invalidateProbeUnchanged();
                }
                if (this.splicedNode != null) {
                    this.splicedNode.enter(node, vFrame);
                }
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.enter(node, vFrame);
                }
            }

            @Override
            public void returnVoid(Node node, VirtualFrame vFrame) {
                if (this.splicedNode != null) {
                    this.splicedNode.returnVoid(node, vFrame);
                }
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnVoid(node, vFrame);
                }
            }

            @Override
            public void returnValue(Node node, VirtualFrame vFrame, Object result) {
                if (this.splicedNode != null) {
                    this.splicedNode.returnValue(node, vFrame, result);
                }
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnValue(node, vFrame, result);
                }
            }

            @Override
            public void returnExceptional(Node node, VirtualFrame vFrame, Exception exception) {
                if (this.splicedNode != null) {
                    this.splicedNode.returnExceptional(node, vFrame, exception);
                }
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnExceptional(node, vFrame, exception);
                }
            }

            @Override
            public String instrumentationInfo() {
                String info = this.getInstrumentInfo();
                return info != null ? info : SpliceInstrument.this.spliceListener.getClass().getSimpleName();
            }
        }
    }

    private static final class StandardInstrument
    extends Instrument {
        private final StandardInstrumentListener standardListener;

        private StandardInstrument(StandardInstrumentListener standardListener, String instrumentInfo) {
            super(instrumentInfo, null);
            this.standardListener = standardListener;
        }

        @Override
        AbstractInstrumentNode addToChain(AbstractInstrumentNode nextNode) {
            return new StandardInstrumentNode(nextNode);
        }

        @Override
        AbstractInstrumentNode removeFromChain(AbstractInstrumentNode instrumentNode) {
            boolean found = false;
            if (instrumentNode != null) {
                if (instrumentNode.getInstrument() == this) {
                    return instrumentNode.nextInstrumentNode;
                }
                found = instrumentNode.removeFromChain(this);
            }
            if (!found) {
                throw new IllegalStateException("Couldn't find instrument node to remove: " + this);
            }
            return instrumentNode;
        }

        @NodeInfo(cost=NodeCost.NONE)
        private final class StandardInstrumentNode
        extends AbstractInstrumentNode {
            private StandardInstrumentNode(AbstractInstrumentNode nextNode) {
                super(nextNode);
            }

            @Override
            public void enter(Node node, VirtualFrame vFrame) {
                StandardInstrument.this.standardListener.enter(StandardInstrument.this.probe, node, vFrame);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.enter(node, vFrame);
                }
            }

            @Override
            public void returnVoid(Node node, VirtualFrame vFrame) {
                StandardInstrument.this.standardListener.returnVoid(StandardInstrument.this.probe, node, vFrame);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnVoid(node, vFrame);
                }
            }

            @Override
            public void returnValue(Node node, VirtualFrame vFrame, Object result) {
                StandardInstrument.this.standardListener.returnValue(StandardInstrument.this.probe, node, vFrame, result);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnValue(node, vFrame, result);
                }
            }

            @Override
            public void returnExceptional(Node node, VirtualFrame vFrame, Exception exception) {
                StandardInstrument.this.standardListener.returnExceptional(StandardInstrument.this.probe, node, vFrame, exception);
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnExceptional(node, vFrame, exception);
                }
            }

            @Override
            public String instrumentationInfo() {
                String info = this.getInstrumentInfo();
                return info != null ? info : StandardInstrument.this.standardListener.getClass().getSimpleName();
            }
        }
    }

    private static final class TruffleOptInstrument
    extends Instrument {
        private final TruffleOptListener toolOptListener;

        private TruffleOptInstrument(TruffleOptListener listener, String instrumentInfo) {
            super(instrumentInfo, null);
            this.toolOptListener = listener;
        }

        @Override
        AbstractInstrumentNode addToChain(AbstractInstrumentNode nextNode) {
            return new TruffleOptInstrumentNode(nextNode);
        }

        @Override
        AbstractInstrumentNode removeFromChain(AbstractInstrumentNode instrumentNode) {
            boolean found = false;
            if (instrumentNode != null) {
                if (instrumentNode.getInstrument() == this) {
                    return instrumentNode.nextInstrumentNode;
                }
                found = instrumentNode.removeFromChain(this);
            }
            if (!found) {
                throw new IllegalStateException("Couldn't find instrument node to remove: " + this);
            }
            return instrumentNode;
        }

        @NodeInfo(cost=NodeCost.NONE)
        private final class TruffleOptInstrumentNode
        extends AbstractInstrumentNode {
            private boolean isCompiled;

            private TruffleOptInstrumentNode(AbstractInstrumentNode nextNode) {
                super(nextNode);
                this.isCompiled = CompilerDirectives.inCompiledCode();
            }

            @Override
            public void enter(Node node, VirtualFrame vFrame) {
                if (this.isCompiled != CompilerDirectives.inCompiledCode()) {
                    this.isCompiled = CompilerDirectives.inCompiledCode();
                    TruffleOptInstrument.this.toolOptListener.notifyIsCompiled(this.isCompiled);
                }
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.enter(node, vFrame);
                }
            }

            @Override
            public void returnVoid(Node node, VirtualFrame vFrame) {
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnVoid(node, vFrame);
                }
            }

            @Override
            public void returnValue(Node node, VirtualFrame vFrame, Object result) {
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnValue(node, vFrame, result);
                }
            }

            @Override
            public void returnExceptional(Node node, VirtualFrame vFrame, Exception exception) {
                if (this.nextInstrumentNode != null) {
                    this.nextInstrumentNode.returnExceptional(node, vFrame, exception);
                }
            }

            @Override
            public String instrumentationInfo() {
                String info = this.getInstrumentInfo();
                return info != null ? info : TruffleOptInstrument.this.toolOptListener.getClass().getSimpleName();
            }
        }
    }

    public static interface TruffleOptListener {
        public void notifyIsCompiled(boolean var1);
    }
}

