/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.methods;

import java.util.Arrays;

public class Arity {
    public static final String[] NO_KEYWORDS = new String[0];
    public static final Arity NO_ARGUMENTS = new Arity(0, 0, false);
    public static final Arity ONE_REQUIRED = new Arity(1, 0, false);
    public static final Arity AT_LEAST_ONE = new Arity(1, 0, true);
    private final int preRequired;
    private final int optional;
    private final boolean hasRest;
    private final int postRequired;
    private final boolean hasKeywordsRest;
    private final String[] keywordArguments;

    public Arity(int preRequired, int optional, boolean hasRest) {
        this(preRequired, optional, hasRest, 0, NO_KEYWORDS, false);
    }

    public Arity(int preRequired, int optional, boolean hasRest, int postRequired, String[] keywordArguments, boolean hasKeywordsRest) {
        this.preRequired = preRequired;
        this.optional = optional;
        this.hasRest = hasRest;
        this.postRequired = postRequired;
        this.keywordArguments = keywordArguments;
        this.hasKeywordsRest = hasKeywordsRest;
        assert (keywordArguments != null && preRequired >= 0 && optional >= 0 && postRequired >= 0) : this.toString();
    }

    public Arity withRest(boolean hasRest) {
        return new Arity(this.preRequired, this.optional, hasRest, this.postRequired, this.keywordArguments, this.hasKeywordsRest);
    }

    public int getPreRequired() {
        return this.preRequired;
    }

    public int getPostRequired() {
        return this.postRequired;
    }

    public int getRequired() {
        return this.preRequired + this.postRequired;
    }

    public int getOptional() {
        return this.optional;
    }

    public boolean hasRest() {
        return this.hasRest;
    }

    public int getRestPosition() {
        return this.preRequired + this.optional;
    }

    public boolean acceptsKeywords() {
        return this.hasKeywords() || this.hasKeywordsRest();
    }

    public boolean hasKeywords() {
        return this.keywordArguments.length != 0;
    }

    public int getKeywordsCount() {
        return this.keywordArguments.length;
    }

    public boolean hasKeywordsRest() {
        return this.hasKeywordsRest;
    }

    public int getArityNumber() {
        int count = this.getRequired();
        if (this.acceptsKeywords()) {
            ++count;
        }
        if (this.optional > 0 || this.hasRest) {
            count = -count - 1;
        }
        return count;
    }

    public String[] getKeywordArguments() {
        return this.keywordArguments;
    }

    public String toString() {
        return "Arity{preRequired=" + this.preRequired + ", optional=" + this.optional + ", hasRest=" + this.hasRest + ", postRequired=" + this.postRequired + ", keywordArguments=" + Arrays.toString(this.keywordArguments) + ", hasKeywordsRest=" + this.hasKeywordsRest + '}';
    }
}

