/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UUOutputStream
extends FilterOutputStream {
    static final byte[] TABLE = new byte[]{96, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95};
    static final int MAX_LINE_LENGTH = 45;
    byte[] line;
    String filename;
    int mode;
    boolean beginLineDone;

    public UUOutputStream(OutputStream out) {
        this(out, null, 384);
    }

    public UUOutputStream(OutputStream out, String filename) {
        this(out, filename, 384);
    }

    public UUOutputStream(OutputStream out, String filename, int mode) {
        super(out);
        if (filename == null) {
            filename = "file";
        }
        this.filename = filename;
        this.mode = mode;
        this.line = new byte[0];
        this.beginLineDone = false;
    }

    void writeBeginLine() throws IOException {
        String beginLine = "begin " + Integer.toString(this.mode, 8) + " " + this.filename + "\n";
        this.out.write(beginLine.getBytes("US-ASCII"));
        this.beginLineDone = true;
    }

    @Override
    public void close() throws IOException {
        this.flush(this.line, 0, this.line.length);
        this.out.write(UUOutputStream.encode(0));
        this.out.write(10);
        this.out.write(new byte[]{101, 110, 100, 10});
        this.out.close();
    }

    @Override
    public void write(int c) throws IOException {
        byte[] buf = new byte[]{(byte)c};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        byte[] tmp = new byte[this.line.length + (len - off)];
        System.arraycopy(this.line, 0, tmp, 0, this.line.length);
        System.arraycopy(buf, off, tmp, this.line.length, len - off);
        this.line = tmp;
        int loff = 0;
        while (this.line.length - loff > 45) {
            this.flush(this.line, loff, 45);
            loff += 45;
        }
        tmp = new byte[this.line.length - loff];
        System.arraycopy(this.line, loff, tmp, 0, tmp.length);
        this.line = tmp;
    }

    void flush(byte[] buf, int off, int len) throws IOException {
        if (!this.beginLineDone) {
            this.writeBeginLine();
        }
        this.out.write(UUOutputStream.encode((byte)len));
        while (len > 2) {
            this.out.write(UUOutputStream.encode(buf[off] >> 2));
            this.out.write(UUOutputStream.encode(buf[off] << 4 & 0x30 | buf[off + 1] >> 4 & 0xF));
            this.out.write(UUOutputStream.encode(buf[off + 1] << 2 & 0x3C | buf[off + 2] >> 6 & 3));
            this.out.write(UUOutputStream.encode(buf[off + 2] & 0x3F));
            len -= 3;
            off += 3;
        }
        if (len != 0) {
            byte c1 = buf[off];
            byte c2 = 0;
            if (len != 1) {
                c2 = buf[off + 1];
            }
            this.out.write(UUOutputStream.encode(c1 >> 2));
            this.out.write(UUOutputStream.encode(c1 << 4 & 0x30 | c2 >> 4 & 0xF));
            if (len == 1) {
                this.out.write(UUOutputStream.encode(0));
            } else {
                this.out.write(UUOutputStream.encode(c2 << 2 & 0x3C));
            }
            this.out.write(UUOutputStream.encode(0));
        }
        this.out.write(10);
    }

    static byte encode(int c) {
        return UUOutputStream.encode((byte)c);
    }

    static byte encode(byte c) {
        int c2 = c;
        if (c2 < 0) {
            c2 += 256;
        }
        return TABLE[c2 & 0x3F];
    }
}

