/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import gnu.inet.util.GetSystemPropertyAction;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.internet.SharedInputStream;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;
    static final String CONTENT_TYPE_NAME = "Content-Type";
    static final String CONTENT_DISPOSITION_NAME = "Content-Disposition";
    static final String CONTENT_TRANSFER_ENCODING_NAME = "Content-Transfer-Encoding";
    static final String CONTENT_ID_NAME = "Content-ID";
    static final String CONTENT_MD5_NAME = "Content-MD5";
    static final String CONTENT_LANGUAGE_NAME = "Content-Language";
    static final String CONTENT_DESCRIPTION_NAME = "Content-Description";
    static final String TEXT_PLAIN = "text/plain";

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream is) throws MessagingException {
        if (is instanceof SharedInputStream) {
            this.headers = new InternetHeaders(is);
            SharedInputStream sis = (SharedInputStream)((Object)is);
            this.contentStream = sis.newStream(sis.getPosition(), -1L);
            return;
        }
        if (!(is instanceof ByteArrayInputStream) && !(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        this.headers = new InternetHeaders(is);
        try {
            int len = 1024;
            if (is instanceof ByteArrayInputStream) {
                len = is.available();
                this.content = new byte[len];
                is.read(this.content, 0, len);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(len);
                byte[] b = new byte[len];
                int l = is.read(b);
                while (l != -1) {
                    bos.write(b, 0, l);
                    l = is.read(b);
                }
                this.content = bos.toByteArray();
            }
        }
        catch (IOException e) {
            throw new MessagingException("I/O error", e);
        }
    }

    public MimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        this.headers = headers;
        this.content = content;
    }

    @Override
    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int len = this.contentStream.available();
                if (len > 0) {
                    return len;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public int getLineCount() throws MessagingException {
        return -1;
    }

    @Override
    public String getContentType() throws MessagingException {
        String contentType = this.getHeader(CONTENT_TYPE_NAME, null);
        if (contentType == null) {
            contentType = TEXT_PLAIN;
        }
        return contentType;
    }

    @Override
    public boolean isMimeType(String mimeType) throws MessagingException {
        String contentType = this.getContentType();
        try {
            return new ContentType(contentType).match(mimeType);
        }
        catch (ParseException e) {
            return this.getContentType().equalsIgnoreCase(mimeType);
        }
    }

    @Override
    public String getDisposition() throws MessagingException {
        String disposition = this.getHeader(CONTENT_DISPOSITION_NAME, null);
        if (disposition != null) {
            return new ContentDisposition(disposition).getDisposition();
        }
        return null;
    }

    @Override
    public void setDisposition(String disposition) throws MessagingException {
        if (disposition == null) {
            this.removeHeader(CONTENT_DISPOSITION_NAME);
        } else {
            String value = this.getHeader(CONTENT_DISPOSITION_NAME, null);
            if (value != null) {
                ContentDisposition cd = new ContentDisposition(value);
                cd.setDisposition(disposition);
                disposition = cd.toString();
            }
            this.setHeader(CONTENT_DISPOSITION_NAME, disposition);
        }
    }

    @Override
    public String getEncoding() throws MessagingException {
        String encoding = this.getHeader(CONTENT_TRANSFER_ENCODING_NAME, null);
        if (encoding != null) {
            if ((encoding = encoding.trim()).equalsIgnoreCase("7bit") || encoding.equalsIgnoreCase("8bit") || encoding.equalsIgnoreCase("quoted-printable") || encoding.equalsIgnoreCase("base64")) {
                return encoding;
            }
            HeaderTokenizer ht = new HeaderTokenizer(encoding, "()<>@,;:\\\"\t []/?=");
            boolean done = false;
            while (!done) {
                HeaderTokenizer.Token token = ht.next();
                switch (token.getType()) {
                    case -4: {
                        done = true;
                        break;
                    }
                    case -1: {
                        return token.getValue();
                    }
                }
            }
            return encoding;
        }
        return null;
    }

    @Override
    public String getContentID() throws MessagingException {
        return this.getHeader(CONTENT_ID_NAME, null);
    }

    public void setContentID(String cid) throws MessagingException {
        if (cid == null) {
            this.removeHeader(CONTENT_ID_NAME);
        } else {
            this.setHeader(CONTENT_ID_NAME, cid);
        }
    }

    @Override
    public String getContentMD5() throws MessagingException {
        return this.getHeader(CONTENT_MD5_NAME, null);
    }

    @Override
    public void setContentMD5(String md5) throws MessagingException {
        this.setHeader(CONTENT_MD5_NAME, md5);
    }

    @Override
    public String[] getContentLanguage() throws MessagingException {
        String header = this.getHeader(CONTENT_LANGUAGE_NAME, null);
        if (header != null) {
            HeaderTokenizer ht = new HeaderTokenizer(header, "()<>@,;:\\\"\t []/?=");
            ArrayList<String> acc = new ArrayList<String>();
            boolean done = false;
            while (!done) {
                HeaderTokenizer.Token token = ht.next();
                switch (token.getType()) {
                    case -4: {
                        done = true;
                        break;
                    }
                    case -1: {
                        acc.add(token.getValue());
                    }
                }
            }
            if (acc.size() > 0) {
                String[] languages = new String[acc.size()];
                acc.toArray(languages);
                return languages;
            }
        }
        return null;
    }

    @Override
    public void setContentLanguage(String[] languages) throws MessagingException {
        if (languages != null && languages.length > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(languages[0]);
            for (int i = 1; i < languages.length; ++i) {
                buffer.append(',');
                buffer.append(languages[i]);
            }
            this.setHeader(CONTENT_LANGUAGE_NAME, buffer.toString());
        } else {
            this.setHeader(CONTENT_LANGUAGE_NAME, null);
        }
    }

    @Override
    public String getDescription() throws MessagingException {
        String header = this.getHeader(CONTENT_DESCRIPTION_NAME, null);
        if (header != null) {
            try {
                return MimeUtility.decodeText(header);
            }
            catch (UnsupportedEncodingException e) {
                return header;
            }
        }
        return null;
    }

    @Override
    public void setDescription(String description) throws MessagingException {
        this.setDescription(description, null);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        if (description != null) {
            try {
                this.setHeader(CONTENT_DESCRIPTION_NAME, MimeUtility.encodeText(description, charset, null));
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("Encode error", e);
            }
        } else {
            this.removeHeader(CONTENT_DESCRIPTION_NAME);
        }
    }

    @Override
    public String getFileName() throws MessagingException {
        GetSystemPropertyAction a;
        String filename = null;
        String header = this.getHeader(CONTENT_DISPOSITION_NAME, null);
        if (header != null) {
            ContentDisposition cd = new ContentDisposition(header);
            filename = cd.getParameter("filename");
        }
        if (filename == null && (header = this.getHeader(CONTENT_TYPE_NAME, null)) != null) {
            try {
                ContentType contentType = new ContentType(header);
                filename = contentType.getParameter("name");
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if ("true".equals(AccessController.doPrivileged(a = new GetSystemPropertyAction("mail.mime.decodefilename")))) {
            try {
                filename = MimeUtility.decodeText(filename);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
        return filename;
    }

    @Override
    public void setFileName(String filename) throws MessagingException {
        String header;
        GetSystemPropertyAction a = new GetSystemPropertyAction("mail.mime.encodefilename");
        if ("true".equals(AccessController.doPrivileged(a))) {
            try {
                filename = MimeUtility.encodeText(filename);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
        if ((header = this.getHeader(CONTENT_DISPOSITION_NAME, null)) == null) {
            header = "attachment";
        }
        ContentDisposition cd = new ContentDisposition(header);
        cd.setParameter("filename", filename);
        this.setHeader(CONTENT_DISPOSITION_NAME, cd.toString());
        header = this.getHeader(CONTENT_TYPE_NAME, null);
        if (header == null) {
            DataHandler dh0 = this.getDataHandler();
            header = dh0 != null ? dh0.getContentType() : TEXT_PLAIN;
        }
        try {
            ContentType contentType = new ContentType(header);
            contentType.setParameter("name", filename);
            this.setHeader(CONTENT_TYPE_NAME, contentType.toString());
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    @Override
    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return ((SharedInputStream)((Object)this.contentStream)).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    @Override
    public DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler((DataSource)new MimePartDataSource(this));
        }
        return this.dh;
    }

    @Override
    public Object getContent() throws IOException, MessagingException {
        return this.getDataHandler().getContent();
    }

    @Override
    public void setDataHandler(DataHandler dh) throws MessagingException {
        this.dh = dh;
        this.removeHeader(CONTENT_TYPE_NAME);
        this.removeHeader(CONTENT_TRANSFER_ENCODING_NAME);
    }

    @Override
    public void setContent(Object o, String type) throws MessagingException {
        if (o instanceof Multipart) {
            this.setContent((Multipart)o);
        } else {
            this.setDataHandler(new DataHandler(o, type));
        }
    }

    @Override
    public void setText(String text) throws MessagingException {
        this.setText(text, null, "plain");
    }

    @Override
    public void setText(String text, String charset) throws MessagingException {
        this.setText(text, charset, "plain");
    }

    @Override
    public void setText(String text, String charset, String subtype) throws MessagingException {
        if (charset == null) {
            charset = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        }
        if (subtype == null || "".equals(subtype)) {
            subtype = "plain";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("text/").append(subtype).append("; charset=");
        buffer.append(MimeUtility.quote(charset, "()<>@,;:\\\"\t []/?="));
        this.setContent(text, buffer.toString());
    }

    @Override
    public void setContent(Multipart mp) throws MessagingException {
        this.setDataHandler(new DataHandler((Object)mp, mp.getContentType()));
        mp.setParent(this);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException, MessagingException {
        String charset = "US-ASCII";
        byte[] sep = new byte[]{13, 10};
        Enumeration e = this.getAllHeaderLines();
        while (e.hasMoreElements()) {
            String line = (String)e.nextElement();
            StringTokenizer st = new StringTokenizer(line, "\r\n");
            int count = 0;
            while (st.hasMoreTokens()) {
                int max;
                String line2 = st.nextToken();
                if (count > 0 && line2.charAt(0) != '\t') {
                    os.write(9);
                }
                int n = max = count > 0 ? 997 : 998;
                while (line2.length() > max) {
                    String left = line2.substring(0, max);
                    byte[] bytes = left.getBytes("US-ASCII");
                    os.write(bytes);
                    os.write(sep);
                    os.write(9);
                    line2 = line2.substring(max);
                    max = 997;
                }
                byte[] bytes = line2.getBytes("US-ASCII");
                os.write(bytes);
                os.write(sep);
                ++count;
            }
        }
        os.write(sep);
        os.flush();
        os = MimeUtility.encode(os, this.getEncoding());
        this.getDataHandler().writeTo(os);
        os.flush();
    }

    @Override
    public String[] getHeader(String name) throws MessagingException {
        return this.headers.getHeader(name);
    }

    @Override
    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.headers.getHeader(name, delimiter);
    }

    @Override
    public void setHeader(String name, String value) throws MessagingException {
        this.headers.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) throws MessagingException {
        this.headers.addHeader(name, value);
    }

    @Override
    public void removeHeader(String name) throws MessagingException {
        this.headers.removeHeader(name);
    }

    @Override
    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    @Override
    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaders(names);
    }

    @Override
    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaders(names);
    }

    @Override
    public void addHeaderLine(String line) throws MessagingException {
        this.headers.addHeaderLine(line);
    }

    @Override
    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    @Override
    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaderLines(names);
    }

    @Override
    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(names);
    }

    protected void updateHeaders() throws MessagingException {
        if (this.getDataHandler() != null) {
            try {
                String contentType = this.dh.getContentType();
                ContentType ct = new ContentType(contentType);
                if (ct.match("multipart/*")) {
                    MimeMultipart mmp = (MimeMultipart)this.dh.getContent();
                    mmp.updateHeaders();
                } else if (!ct.match("message/rfc822") && this.getHeader(CONTENT_TRANSFER_ENCODING_NAME) == null) {
                    this.setHeader(CONTENT_TRANSFER_ENCODING_NAME, MimeUtility.getEncoding(this.dh));
                }
                if (this.getHeader(CONTENT_TYPE_NAME) == null) {
                    ContentDisposition cd;
                    String filename;
                    String disposition = this.getHeader(CONTENT_DISPOSITION_NAME, null);
                    if (disposition != null && (filename = (cd = new ContentDisposition(disposition)).getParameter("filename")) != null) {
                        ct.setParameter("name", filename);
                        contentType = ct.toString();
                    }
                    this.setHeader(CONTENT_TYPE_NAME, contentType);
                }
            }
            catch (IOException e) {
                throw new MessagingException("I/O error", e);
            }
        }
    }

    public void attachFile(File file) throws IOException, MessagingException {
        FileTypeMap map = FileTypeMap.getDefaultFileTypeMap();
        String contentType = map.getContentType(file);
        if (contentType == null) {
            throw new MessagingException("Unable to determine MIME type of " + file);
        }
        this.setContent(new FileInputStream(file), contentType);
        this.setFileName(file.getName());
    }

    public void attachFile(String file) throws IOException, MessagingException {
        this.attachFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file) throws IOException, MessagingException {
        try (OutputStream out = new FileOutputStream(file);){
            out = MimeUtility.encode(out, this.getEncoding());
            this.getDataHandler().writeTo(out);
            out.flush();
        }
    }

    public void saveFile(String file) throws IOException, MessagingException {
        this.saveFile(new File(file));
    }
}

