/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jdepend.framework.PropertyConfigurator;

public class PackageFilter {
    private Collection filtered = new ArrayList();

    public PackageFilter() {
        this(new ArrayList());
        PropertyConfigurator config = new PropertyConfigurator();
        this.addPackages(config.getFilteredPackages());
    }

    public PackageFilter(File f) {
        this(new ArrayList());
        PropertyConfigurator config = new PropertyConfigurator(f);
        this.addPackages(config.getFilteredPackages());
    }

    public PackageFilter(Collection packageNames) {
        this.addPackages(packageNames);
    }

    public Collection getFilters() {
        return this.filtered;
    }

    public boolean accept(String packageName) {
        for (String nameToFilter : this.getFilters()) {
            if (!packageName.startsWith(nameToFilter)) continue;
            return false;
        }
        return true;
    }

    public void addPackages(Collection packageNames) {
        Iterator i = packageNames.iterator();
        while (i.hasNext()) {
            this.addPackage((String)i.next());
        }
    }

    public void addPackage(String packageName) {
        if (packageName.endsWith("*")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        if (packageName.length() > 0) {
            this.getFilters().add(packageName);
        }
    }
}

