/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XMBean;

public class XMBeanInfo
extends JPanel {
    private static final Color lightYellow = new Color(255, 255, 128);
    private final int NAME_COLUMN = 0;
    private final int VALUE_COLUMN = 1;
    private final String[] columnNames = new String[]{Messages.NAME, Messages.VALUE};
    private JTable infoTable = new JTable();
    private JTable descTable = new JTable();
    private JPanel infoBorderPanel = new JPanel(new BorderLayout());
    private JPanel descBorderPanel = new JPanel(new BorderLayout());
    private static MBeanInfoTableCellRenderer renderer = new MBeanInfoTableCellRenderer();
    private static TableCellEditor editor = new MBeanInfoTableCellEditor(new JTextField());

    public XMBeanInfo() {
        super(new GridLayout(2, 1));
        this.infoTable.setModel(new ReadOnlyDefaultTableModel());
        this.infoTable.setRowSelectionAllowed(false);
        this.infoTable.setColumnSelectionAllowed(false);
        this.infoTable.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableModel)this.infoTable.getModel()).setColumnIdentifiers(this.columnNames);
        this.infoTable.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.infoTable.getColumnModel().getColumn(0).setMaxWidth(140);
        this.infoTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.infoTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.infoTable.getColumnModel().getColumn(0).setCellEditor(editor);
        this.infoTable.getColumnModel().getColumn(1).setCellEditor(editor);
        this.infoTable.addKeyListener(new Utils.CopyKeyAdapter());
        this.infoTable.setAutoResizeMode(2);
        JScrollPane infoTableScrollPane = new JScrollPane(this.infoTable);
        this.infoBorderPanel.setBorder(BorderFactory.createTitledBorder("MBeanInfoPlaceHolder"));
        this.infoBorderPanel.add(infoTableScrollPane);
        this.descTable.setModel(new ReadOnlyDefaultTableModel());
        this.descTable.setRowSelectionAllowed(false);
        this.descTable.setColumnSelectionAllowed(false);
        this.descTable.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableModel)this.descTable.getModel()).setColumnIdentifiers(this.columnNames);
        this.descTable.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.descTable.getColumnModel().getColumn(0).setMaxWidth(140);
        this.descTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.descTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.descTable.getColumnModel().getColumn(0).setCellEditor(editor);
        this.descTable.getColumnModel().getColumn(1).setCellEditor(editor);
        this.descTable.addKeyListener(new Utils.CopyKeyAdapter());
        this.descTable.setAutoResizeMode(2);
        JScrollPane descTableScrollPane = new JScrollPane(this.descTable);
        this.descBorderPanel.setBorder(BorderFactory.createTitledBorder(Messages.DESCRIPTOR));
        this.descBorderPanel.add(descTableScrollPane);
        this.add(this.infoBorderPanel);
        this.add(this.descBorderPanel);
    }

    public void emptyInfoTable() {
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
    }

    public void emptyDescTable() {
        DefaultTableModel tableModel = (DefaultTableModel)this.descTable.getModel();
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
    }

    private void addDescriptor(Descriptor desc, String text) {
        if (desc != null && desc.getFieldNames().length > 0) {
            DefaultTableModel tableModel = (DefaultTableModel)this.descTable.getModel();
            Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
            tableModel.addRow(rowData);
            for (String fieldName : desc.getFieldNames()) {
                rowData[0] = fieldName;
                Object fieldValue = desc.getFieldValue(fieldName);
                rowData[1] = fieldValue instanceof boolean[] ? Arrays.toString((boolean[])fieldValue) : (fieldValue instanceof byte[] ? Arrays.toString((byte[])fieldValue) : (fieldValue instanceof char[] ? Arrays.toString((char[])fieldValue) : (fieldValue instanceof double[] ? Arrays.toString((double[])fieldValue) : (fieldValue instanceof float[] ? Arrays.toString((float[])fieldValue) : (fieldValue instanceof int[] ? Arrays.toString((int[])fieldValue) : (fieldValue instanceof long[] ? Arrays.toString((long[])fieldValue) : (fieldValue instanceof short[] ? Arrays.toString((short[])fieldValue) : (fieldValue instanceof Object[] ? Arrays.toString((Object[])fieldValue) : fieldValue))))))));
                tableModel.addRow(rowData);
            }
            tableModel.newDataAvailable(new TableModelEvent(tableModel));
        }
    }

    public void addMBeanInfo(XMBean mbean, MBeanInfo mbeanInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Messages.MBEAN_INFO);
        String text = Messages.INFO + ":";
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Messages.OBJECT_NAME;
        rowData[1] = mbean.getObjectName();
        tableModel.addRow(rowData);
        rowData[0] = Messages.CLASS_NAME;
        rowData[1] = mbeanInfo.getClassName();
        tableModel.addRow(rowData);
        rowData[0] = Messages.DESCRIPTION;
        rowData[1] = mbeanInfo.getDescription();
        tableModel.addRow(rowData);
        this.addDescriptor(mbeanInfo.getDescriptor(), text);
        int i = 0;
        for (MBeanConstructorInfo mbci : mbeanInfo.getConstructors()) {
            this.addMBeanConstructorInfo(mbci, Messages.CONSTRUCTOR + "-" + i + ":");
            int j = 0;
            for (MBeanParameterInfo mbpi : mbci.getSignature()) {
                this.addMBeanParameterInfo(mbpi, Messages.PARAMETER + "-" + i + "-" + j + ":");
                ++j;
            }
            ++i;
        }
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    public void addMBeanAttributeInfo(MBeanAttributeInfo mbai) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Messages.MBEAN_ATTRIBUTE_INFO);
        String text = Messages.ATTRIBUTE + ":";
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Messages.NAME;
        rowData[1] = mbai.getName();
        tableModel.addRow(rowData);
        rowData[0] = Messages.DESCRIPTION;
        rowData[1] = mbai.getDescription();
        tableModel.addRow(rowData);
        rowData[0] = Messages.READABLE;
        rowData[1] = mbai.isReadable();
        tableModel.addRow(rowData);
        rowData[0] = Messages.WRITABLE;
        rowData[1] = mbai.isWritable();
        tableModel.addRow(rowData);
        rowData[0] = Messages.IS;
        rowData[1] = mbai.isIs();
        tableModel.addRow(rowData);
        rowData[0] = Messages.TYPE;
        rowData[1] = mbai.getType();
        tableModel.addRow(rowData);
        this.addDescriptor(mbai.getDescriptor(), text);
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    public void addMBeanOperationInfo(MBeanOperationInfo mboi) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Messages.MBEAN_OPERATION_INFO);
        String text = Messages.OPERATION + ":";
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Messages.NAME;
        rowData[1] = mboi.getName();
        tableModel.addRow(rowData);
        rowData[0] = Messages.DESCRIPTION;
        rowData[1] = mboi.getDescription();
        tableModel.addRow(rowData);
        rowData[0] = Messages.IMPACT;
        switch (mboi.getImpact()) {
            case 0: {
                rowData[1] = Messages.INFO_CAPITALIZED;
                break;
            }
            case 1: {
                rowData[1] = Messages.ACTION_CAPITALIZED;
                break;
            }
            case 2: {
                rowData[1] = Messages.ACTION_INFO_CAPITALIZED;
                break;
            }
            case 3: {
                rowData[1] = Messages.UNKNOWN_CAPITALIZED;
            }
        }
        tableModel.addRow(rowData);
        rowData[0] = Messages.RETURN_TYPE;
        rowData[1] = mboi.getReturnType();
        tableModel.addRow(rowData);
        this.addDescriptor(mboi.getDescriptor(), text);
        int i = 0;
        for (MBeanParameterInfo mbpi : mboi.getSignature()) {
            this.addMBeanParameterInfo(mbpi, Messages.PARAMETER + "-" + i++ + ":");
        }
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    public void addMBeanNotificationInfo(MBeanNotificationInfo mbni) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Messages.MBEAN_NOTIFICATION_INFO);
        String text = Messages.NOTIFICATION + ":";
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Messages.NAME;
        rowData[1] = mbni.getName();
        tableModel.addRow(rowData);
        rowData[0] = Messages.DESCRIPTION;
        rowData[1] = mbni.getDescription();
        tableModel.addRow(rowData);
        rowData[0] = Messages.NOTIF_TYPES;
        rowData[1] = Arrays.toString(mbni.getNotifTypes());
        tableModel.addRow(rowData);
        this.addDescriptor(mbni.getDescriptor(), text);
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    private void addMBeanConstructorInfo(MBeanConstructorInfo mbci, String text) {
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Messages.NAME;
        rowData[1] = mbci.getName();
        tableModel.addRow(rowData);
        rowData[0] = Messages.DESCRIPTION;
        rowData[1] = mbci.getDescription();
        tableModel.addRow(rowData);
        this.addDescriptor(mbci.getDescriptor(), text);
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    private void addMBeanParameterInfo(MBeanParameterInfo mbpi, String text) {
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Messages.NAME;
        rowData[1] = mbpi.getName();
        tableModel.addRow(rowData);
        rowData[0] = Messages.DESCRIPTION;
        rowData[1] = mbpi.getDescription();
        tableModel.addRow(rowData);
        rowData[0] = Messages.TYPE;
        rowData[1] = mbpi.getType();
        tableModel.addRow(rowData);
        this.addDescriptor(mbpi.getDescriptor(), text);
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    private static class MBeanInfoTableCellEditor
    extends Utils.ReadOnlyTableCellEditor {
        public MBeanInfoTableCellEditor(JTextField tf) {
            super(tf);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value instanceof TableRowDivider) {
                JLabel label = new JLabel(value.toString());
                label.setBackground(Utilities.ensureContrast(lightYellow, label.getForeground()));
                label.setOpaque(true);
                return label;
            }
            return comp;
        }
    }

    private static class MBeanInfoTableCellRenderer
    extends DefaultTableCellRenderer {
        private MBeanInfoTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof TableRowDivider) {
                JLabel label = new JLabel(value.toString());
                label.setBackground(Utilities.ensureContrast(lightYellow, label.getForeground()));
                label.setOpaque(true);
                return label;
            }
            return comp;
        }
    }

    private static class TableRowDivider {
        private String tableRowDividerText;

        public TableRowDivider(String tableRowDividerText) {
            this.tableRowDividerText = tableRowDividerText;
        }

        public String toString() {
            return this.tableRowDividerText;
        }
    }

    private static class ReadOnlyDefaultTableModel
    extends DefaultTableModel {
        private ReadOnlyDefaultTableModel() {
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }
}

