/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteJIS0201;
import sun.io.CharToByteSJIS;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Encoder;

public class CharToBytePCK
extends CharToByteSJIS {
    CharToByteJIS0201 cbJIS0201 = new CharToByteJIS0201();
    short[] j0208Index1 = JIS_X_0208_Solaris_Encoder.getIndex1();
    String[] j0208Index2 = JIS_X_0208_Solaris_Encoder.getIndex2();

    @Override
    public String getCharacterEncoding() {
        return "PCK";
    }

    @Override
    protected int convSingleByte(char inputChar, byte[] outputByte) {
        if ((inputChar & 0xFF80) == 0) {
            outputByte[0] = (byte)inputChar;
            return 1;
        }
        byte b = this.cbJIS0201.getNative(inputChar);
        if (b == 0) {
            return 0;
        }
        outputByte[0] = b;
        return 1;
    }

    @Override
    protected int getNative(char ch) {
        int result = 0;
        switch (ch) {
            case '\u2015': {
                return 33116;
            }
            case '\u2014': {
                return 0;
            }
        }
        result = super.getNative(ch);
        if (result != 0) {
            return result;
        }
        int offset = this.j0208Index1[ch >> 8] << 8;
        char pos = this.j0208Index2[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
        if (pos != '\u0000') {
            int rowOffset;
            int c1 = pos >> 8 & 0xFF;
            int c2 = pos & 0xFF;
            int n = rowOffset = c1 < 95 ? 112 : 176;
            int cellOffset = c1 % 2 == 1 ? (c2 > 95 ? 32 : 31) : 126;
            result = (c1 + 1 >> 1) + rowOffset << 8 | c2 + cellOffset;
        }
        return result;
    }
}

