/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.TlsPrfGenerator;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

final class SslMacCore {
    private final MessageDigest md;
    private final byte[] pad1;
    private final byte[] pad2;
    private boolean first;
    private byte[] secret;

    SslMacCore(String digestAlgorithm, byte[] pad1, byte[] pad2) throws NoSuchAlgorithmException {
        this.md = MessageDigest.getInstance(digestAlgorithm);
        this.pad1 = pad1;
        this.pad2 = pad2;
        this.first = true;
    }

    int getDigestLength() {
        return this.md.getDigestLength();
    }

    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("SslMac does not use parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        this.secret = key.getEncoded();
        if (this.secret == null || this.secret.length == 0) {
            throw new InvalidKeyException("Missing key data");
        }
        this.reset();
    }

    void update(byte input) {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
            this.first = false;
        }
        this.md.update(input);
    }

    void update(byte[] input, int offset, int len) {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
            this.first = false;
        }
        this.md.update(input, offset, len);
    }

    void update(ByteBuffer input) {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
            this.first = false;
        }
        this.md.update(input);
    }

    byte[] doFinal() {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
        } else {
            this.first = true;
        }
        try {
            byte[] tmp = this.md.digest();
            this.md.update(this.secret);
            this.md.update(this.pad2);
            this.md.update(tmp);
            this.md.digest(tmp, 0, tmp.length);
            return tmp;
        }
        catch (DigestException e) {
            throw new ProviderException(e);
        }
    }

    void reset() {
        if (!this.first) {
            this.md.reset();
            this.first = true;
        }
    }

    public static final class SslMacSHA1
    extends MacSpi {
        private final SslMacCore core = new SslMacCore("SHA", shaPad1, shaPad2);
        static final byte[] shaPad1 = TlsPrfGenerator.genPad((byte)54, 40);
        static final byte[] shaPad2 = TlsPrfGenerator.genPad((byte)92, 40);

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, params);
        }

        @Override
        protected void engineUpdate(byte input) {
            this.core.update(input);
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            this.core.update(input, offset, len);
        }

        @Override
        protected void engineUpdate(ByteBuffer input) {
            this.core.update(input);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }
    }

    public static final class SslMacMD5
    extends MacSpi {
        private final SslMacCore core = new SslMacCore("MD5", md5Pad1, md5Pad2);
        static final byte[] md5Pad1 = TlsPrfGenerator.genPad((byte)54, 48);
        static final byte[] md5Pad2 = TlsPrfGenerator.genPad((byte)92, 48);

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, params);
        }

        @Override
        protected void engineUpdate(byte input) {
            this.core.update(input);
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            this.core.update(input, offset, len);
        }

        @Override
        protected void engineUpdate(ByteBuffer input) {
            this.core.update(input);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }
    }
}

