/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DHTMarkerSegment
extends MarkerSegment {
    List tables = new ArrayList();

    DHTMarkerSegment(boolean needFour) {
        super(196);
        this.tables.add(new Htable(JPEGHuffmanTable.StdDCLuminance, true, 0));
        if (needFour) {
            this.tables.add(new Htable(JPEGHuffmanTable.StdDCChrominance, true, 1));
        }
        this.tables.add(new Htable(JPEGHuffmanTable.StdACLuminance, false, 0));
        if (needFour) {
            this.tables.add(new Htable(JPEGHuffmanTable.StdACChrominance, false, 1));
        }
    }

    DHTMarkerSegment(JPEGBuffer buffer) throws IOException {
        super(buffer);
        Htable newGuy;
        for (int count = this.length; count > 0; count -= 17 + newGuy.values.length) {
            newGuy = new Htable(buffer);
            this.tables.add(newGuy);
        }
        buffer.bufAvail -= this.length;
    }

    DHTMarkerSegment(JPEGHuffmanTable[] dcTables, JPEGHuffmanTable[] acTables) {
        super(196);
        int i;
        for (i = 0; i < dcTables.length; ++i) {
            this.tables.add(new Htable(dcTables[i], true, i));
        }
        for (i = 0; i < acTables.length; ++i) {
            this.tables.add(new Htable(acTables[i], false, i));
        }
    }

    DHTMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(196);
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        if (size < 1 || size > 4) {
            throw new IIOInvalidTreeException("Invalid DHT node", node);
        }
        for (int i = 0; i < size; ++i) {
            this.tables.add(new Htable(children.item(i)));
        }
    }

    @Override
    protected Object clone() {
        DHTMarkerSegment newGuy = (DHTMarkerSegment)super.clone();
        newGuy.tables = new ArrayList(this.tables.size());
        for (Htable table : this.tables) {
            newGuy.tables.add(table.clone());
        }
        return newGuy;
    }

    @Override
    IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode("dht");
        for (int i = 0; i < this.tables.size(); ++i) {
            Htable table = (Htable)this.tables.get(i);
            node.appendChild(table.getNativeNode());
        }
        return node;
    }

    @Override
    void write(ImageOutputStream ios) throws IOException {
    }

    @Override
    void print() {
        this.printTag("DHT");
        System.out.println("Num tables: " + Integer.toString(this.tables.size()));
        for (int i = 0; i < this.tables.size(); ++i) {
            Htable table = (Htable)this.tables.get(i);
            table.print();
        }
        System.out.println();
    }

    Htable getHtableFromNode(Node node) throws IIOInvalidTreeException {
        return new Htable(node);
    }

    void addHtable(JPEGHuffmanTable table, boolean isDC, int id) {
        this.tables.add(new Htable(table, isDC, id));
    }

    class Htable
    implements Cloneable {
        int tableClass;
        int tableID;
        private static final int NUM_LENGTHS = 16;
        short[] numCodes = new short[16];
        short[] values;

        Htable(JPEGBuffer buffer) {
            int i;
            this.tableClass = buffer.buf[buffer.bufPtr] >>> 4;
            this.tableID = buffer.buf[buffer.bufPtr++] & 0xF;
            for (int i2 = 0; i2 < 16; ++i2) {
                this.numCodes[i2] = (short)(buffer.buf[buffer.bufPtr++] & 0xFF);
            }
            int numValues = 0;
            for (i = 0; i < 16; ++i) {
                numValues += this.numCodes[i];
            }
            this.values = new short[numValues];
            for (i = 0; i < numValues; ++i) {
                this.values[i] = (short)(buffer.buf[buffer.bufPtr++] & 0xFF);
            }
        }

        Htable(JPEGHuffmanTable table, boolean isDC, int id) {
            this.tableClass = isDC ? 0 : 1;
            this.tableID = id;
            this.numCodes = table.getLengths();
            this.values = table.getValues();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Htable(Node node) throws IIOInvalidTreeException {
            if (!node.getNodeName().equals("dhtable")) throw new IIOInvalidTreeException("Invalid node, expected dqtable", node);
            NamedNodeMap attrs = node.getAttributes();
            int count = attrs.getLength();
            if (count != 2) {
                throw new IIOInvalidTreeException("dhtable node must have 2 attributes", node);
            }
            this.tableClass = MarkerSegment.getAttributeValue(node, attrs, "class", 0, 1, true);
            this.tableID = MarkerSegment.getAttributeValue(node, attrs, "htableId", 0, 3, true);
            if (!(node instanceof IIOMetadataNode)) throw new IIOInvalidTreeException("dhtable node must have user object", node);
            IIOMetadataNode ourNode = (IIOMetadataNode)node;
            JPEGHuffmanTable table = (JPEGHuffmanTable)ourNode.getUserObject();
            if (table == null) {
                throw new IIOInvalidTreeException("dhtable node must have user object", node);
            }
            this.numCodes = table.getLengths();
            this.values = table.getValues();
        }

        protected Object clone() {
            Htable newGuy = null;
            try {
                newGuy = (Htable)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.numCodes != null) {
                newGuy.numCodes = (short[])this.numCodes.clone();
            }
            if (this.values != null) {
                newGuy.values = (short[])this.values.clone();
            }
            return newGuy;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode node = new IIOMetadataNode("dhtable");
            node.setAttribute("class", Integer.toString(this.tableClass));
            node.setAttribute("htableId", Integer.toString(this.tableID));
            node.setUserObject(new JPEGHuffmanTable(this.numCodes, this.values));
            return node;
        }

        void print() {
            System.out.println("Huffman Table");
            System.out.println("table class: " + (this.tableClass == 0 ? "DC" : "AC"));
            System.out.println("table id: " + Integer.toString(this.tableID));
            new JPEGHuffmanTable(this.numCodes, this.values).toString();
        }
    }
}

