/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.ChunkStream;
import com.sun.imageio.plugins.png.IDATOutputStream;
import com.sun.imageio.plugins.png.PNGImageReader;
import com.sun.imageio.plugins.png.PNGImageWriteParam;
import com.sun.imageio.plugins.png.PNGMetadata;
import com.sun.imageio.plugins.png.RowFilter;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class PNGImageWriter
extends ImageWriter {
    ImageOutputStream stream = null;
    PNGMetadata metadata = null;
    int sourceXOffset = 0;
    int sourceYOffset = 0;
    int sourceWidth = 0;
    int sourceHeight = 0;
    int[] sourceBands = null;
    int periodX = 1;
    int periodY = 1;
    int numBands;
    int bpp;
    RowFilter rowFilter = new RowFilter();
    byte[] prevRow = null;
    byte[] currRow = null;
    byte[][] filteredRows = null;
    int[] sampleSize = null;
    int scalingBitDepth = -1;
    byte[][] scale = null;
    byte[] scale0 = null;
    byte[][] scaleh = null;
    byte[][] scalel = null;
    int totalPixels;
    int pixelsDone;
    private static int[] allowedProgressivePasses = new int[]{1, 7};

    public PNGImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output not an ImageOutputStream!");
            }
            this.stream = (ImageOutputStream)output;
        } else {
            this.stream = null;
        }
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new PNGImageWriteParam(this.getLocale());
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        PNGMetadata m = new PNGMetadata();
        m.initialize(imageType, imageType.getSampleModel().getNumBands());
        return m;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        if (inData instanceof PNGMetadata) {
            return (PNGMetadata)((PNGMetadata)inData).clone();
        }
        return new PNGMetadata(inData);
    }

    private void write_magic() throws IOException {
        byte[] magic = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.stream.write(magic);
    }

    private void write_IHDR() throws IOException {
        ChunkStream cs = new ChunkStream(1229472850, this.stream);
        cs.writeInt(this.metadata.IHDR_width);
        cs.writeInt(this.metadata.IHDR_height);
        cs.writeByte(this.metadata.IHDR_bitDepth);
        cs.writeByte(this.metadata.IHDR_colorType);
        if (this.metadata.IHDR_compressionMethod != 0) {
            throw new IIOException("Only compression method 0 is defined in PNG 1.1");
        }
        cs.writeByte(this.metadata.IHDR_compressionMethod);
        if (this.metadata.IHDR_filterMethod != 0) {
            throw new IIOException("Only filter method 0 is defined in PNG 1.1");
        }
        cs.writeByte(this.metadata.IHDR_filterMethod);
        if (this.metadata.IHDR_interlaceMethod < 0 || this.metadata.IHDR_interlaceMethod > 1) {
            throw new IIOException("Only interlace methods 0 (node) and 1 (adam7) are defined in PNG 1.1");
        }
        cs.writeByte(this.metadata.IHDR_interlaceMethod);
        cs.finish();
    }

    private void write_cHRM() throws IOException {
        if (this.metadata.cHRM_present) {
            ChunkStream cs = new ChunkStream(1665684045, this.stream);
            cs.writeInt(this.metadata.cHRM_whitePointX);
            cs.writeInt(this.metadata.cHRM_whitePointY);
            cs.writeInt(this.metadata.cHRM_redX);
            cs.writeInt(this.metadata.cHRM_redY);
            cs.writeInt(this.metadata.cHRM_greenX);
            cs.writeInt(this.metadata.cHRM_greenY);
            cs.writeInt(this.metadata.cHRM_blueX);
            cs.writeInt(this.metadata.cHRM_blueY);
            cs.finish();
        }
    }

    private void write_gAMA() throws IOException {
        if (this.metadata.gAMA_present) {
            ChunkStream cs = new ChunkStream(1732332865, this.stream);
            cs.writeInt(this.metadata.gAMA_gamma);
            cs.finish();
        }
    }

    private void write_iCCP() throws IOException {
        if (this.metadata.iCCP_present) {
            ChunkStream cs = new ChunkStream(1766015824, this.stream);
            cs.writeBytes(this.metadata.iCCP_profileName);
            cs.writeByte(0);
            cs.writeByte(this.metadata.iCCP_compressionMethod);
            cs.write(this.metadata.iCCP_compressedProfile);
            cs.finish();
        }
    }

    private void write_sBIT() throws IOException {
        if (this.metadata.sBIT_present) {
            ChunkStream cs = new ChunkStream(1933723988, this.stream);
            int colorType = this.metadata.IHDR_colorType;
            if (this.metadata.sBIT_colorType != colorType) {
                this.processWarningOccurred(0, "sBIT metadata has wrong color type.\nThe chunk will not be written.");
                return;
            }
            if (colorType == 0 || colorType == 4) {
                cs.writeByte(this.metadata.sBIT_grayBits);
            } else if (colorType == 2 || colorType == 3 || colorType == 6) {
                cs.writeByte(this.metadata.sBIT_redBits);
                cs.writeByte(this.metadata.sBIT_greenBits);
                cs.writeByte(this.metadata.sBIT_blueBits);
            }
            if (colorType == 4 || colorType == 6) {
                cs.writeByte(this.metadata.sBIT_alphaBits);
            }
            cs.finish();
        }
    }

    private void write_sRGB() throws IOException {
        if (this.metadata.sRGB_present) {
            ChunkStream cs = new ChunkStream(1934772034, this.stream);
            cs.writeByte(this.metadata.sRGB_renderingIntent);
            cs.finish();
        }
    }

    private void write_PLTE() throws IOException {
        if (this.metadata.PLTE_present) {
            if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
                this.processWarningOccurred(0, "A PLTE chunk may not appear in a gray or gray alpha image.\nThe chunk will not be written");
                return;
            }
            ChunkStream cs = new ChunkStream(1347179589, this.stream);
            int numEntries = this.metadata.PLTE_red.length;
            byte[] palette = new byte[numEntries * 3];
            int index = 0;
            for (int i = 0; i < numEntries; ++i) {
                palette[index++] = this.metadata.PLTE_red[i];
                palette[index++] = this.metadata.PLTE_green[i];
                palette[index++] = this.metadata.PLTE_blue[i];
            }
            cs.write(palette);
            cs.finish();
        }
    }

    private void write_hIST() throws IOException, IIOException {
        if (this.metadata.hIST_present) {
            ChunkStream cs = new ChunkStream(1749635924, this.stream);
            if (!this.metadata.PLTE_present) {
                throw new IIOException("hIST chunk without PLTE chunk!");
            }
            cs.writeChars(this.metadata.hIST_histogram, 0, this.metadata.hIST_histogram.length);
            cs.finish();
        }
    }

    private void write_tRNS() throws IOException, IIOException {
        if (this.metadata.tRNS_present) {
            ChunkStream cs = new ChunkStream(1951551059, this.stream);
            int colorType = this.metadata.IHDR_colorType;
            int chunkType = this.metadata.tRNS_colorType;
            int chunkRed = this.metadata.tRNS_red;
            int chunkGreen = this.metadata.tRNS_green;
            int chunkBlue = this.metadata.tRNS_blue;
            if (colorType == 2 && chunkType == 0) {
                chunkType = colorType;
                chunkGreen = chunkBlue = this.metadata.tRNS_gray;
                chunkRed = chunkBlue;
            }
            if (chunkType != colorType) {
                this.processWarningOccurred(0, "tRNS metadata has incompatible color type.\nThe chunk will not be written.");
                return;
            }
            if (colorType == 3) {
                if (!this.metadata.PLTE_present) {
                    throw new IIOException("tRNS chunk without PLTE chunk!");
                }
                cs.write(this.metadata.tRNS_alpha);
            } else if (colorType == 0) {
                cs.writeShort(this.metadata.tRNS_gray);
            } else if (colorType == 2) {
                cs.writeShort(chunkRed);
                cs.writeShort(chunkGreen);
                cs.writeShort(chunkBlue);
            } else {
                throw new IIOException("tRNS chunk for color type 4 or 6!");
            }
            cs.finish();
        }
    }

    private void write_bKGD() throws IOException {
        if (this.metadata.bKGD_present) {
            ChunkStream cs = new ChunkStream(1649100612, this.stream);
            int colorType = this.metadata.IHDR_colorType & 3;
            int chunkType = this.metadata.bKGD_colorType;
            int chunkRed = this.metadata.bKGD_red;
            int chunkGreen = this.metadata.bKGD_red;
            int chunkBlue = this.metadata.bKGD_red;
            if (colorType == 2 && chunkType == 0) {
                chunkType = colorType;
                chunkGreen = chunkBlue = this.metadata.bKGD_gray;
                chunkRed = chunkBlue;
            }
            if (chunkType != colorType) {
                this.processWarningOccurred(0, "bKGD metadata has incompatible color type.\nThe chunk will not be written.");
                return;
            }
            if (colorType == 3) {
                cs.writeByte(this.metadata.bKGD_index);
            } else if (colorType == 0 || colorType == 4) {
                cs.writeShort(this.metadata.bKGD_gray);
            } else {
                cs.writeShort(chunkRed);
                cs.writeShort(chunkGreen);
                cs.writeShort(chunkBlue);
            }
            cs.finish();
        }
    }

    private void write_pHYs() throws IOException {
        if (this.metadata.pHYs_present) {
            ChunkStream cs = new ChunkStream(1883789683, this.stream);
            cs.writeInt(this.metadata.pHYs_pixelsPerUnitXAxis);
            cs.writeInt(this.metadata.pHYs_pixelsPerUnitYAxis);
            cs.writeByte(this.metadata.pHYs_unitSpecifier);
            cs.finish();
        }
    }

    private void write_sPLT() throws IOException {
        if (this.metadata.sPLT_present) {
            ChunkStream cs = new ChunkStream(1934642260, this.stream);
            cs.writeBytes(this.metadata.sPLT_paletteName);
            cs.writeByte(0);
            cs.writeByte(this.metadata.sPLT_sampleDepth);
            int numEntries = this.metadata.sPLT_red.length;
            if (this.metadata.sPLT_sampleDepth == 8) {
                for (int i = 0; i < numEntries; ++i) {
                    cs.writeByte(this.metadata.sPLT_red[i]);
                    cs.writeByte(this.metadata.sPLT_green[i]);
                    cs.writeByte(this.metadata.sPLT_blue[i]);
                    cs.writeByte(this.metadata.sPLT_alpha[i]);
                    cs.writeShort(this.metadata.sPLT_frequency[i]);
                }
            } else {
                for (int i = 0; i < numEntries; ++i) {
                    cs.writeShort(this.metadata.sPLT_red[i]);
                    cs.writeShort(this.metadata.sPLT_green[i]);
                    cs.writeShort(this.metadata.sPLT_blue[i]);
                    cs.writeShort(this.metadata.sPLT_alpha[i]);
                    cs.writeShort(this.metadata.sPLT_frequency[i]);
                }
            }
            cs.finish();
        }
    }

    private void write_tIME() throws IOException {
        if (this.metadata.tIME_present) {
            ChunkStream cs = new ChunkStream(1950960965, this.stream);
            cs.writeShort(this.metadata.tIME_year);
            cs.writeByte(this.metadata.tIME_month);
            cs.writeByte(this.metadata.tIME_day);
            cs.writeByte(this.metadata.tIME_hour);
            cs.writeByte(this.metadata.tIME_minute);
            cs.writeByte(this.metadata.tIME_second);
            cs.finish();
        }
    }

    private void write_tEXt() throws IOException {
        Iterator<String> keywordIter = this.metadata.tEXt_keyword.iterator();
        Iterator<String> textIter = this.metadata.tEXt_text.iterator();
        while (keywordIter.hasNext()) {
            ChunkStream cs = new ChunkStream(1950701684, this.stream);
            String keyword = keywordIter.next();
            cs.writeBytes(keyword);
            cs.writeByte(0);
            String text = textIter.next();
            cs.writeBytes(text);
            cs.finish();
        }
    }

    private byte[] deflate(byte[] b) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(baos);
        dos.write(b);
        dos.close();
        return baos.toByteArray();
    }

    private void write_iTXt() throws IOException {
        Iterator<String> keywordIter = this.metadata.iTXt_keyword.iterator();
        Iterator<Boolean> flagIter = this.metadata.iTXt_compressionFlag.iterator();
        Iterator<Integer> methodIter = this.metadata.iTXt_compressionMethod.iterator();
        Iterator<String> languageIter = this.metadata.iTXt_languageTag.iterator();
        Iterator<String> translatedKeywordIter = this.metadata.iTXt_translatedKeyword.iterator();
        Iterator<String> textIter = this.metadata.iTXt_text.iterator();
        while (keywordIter.hasNext()) {
            ChunkStream cs = new ChunkStream(1767135348, this.stream);
            cs.writeBytes(keywordIter.next());
            cs.writeByte(0);
            Boolean compressed = flagIter.next();
            cs.writeByte(compressed != false ? 1 : 0);
            cs.writeByte(methodIter.next());
            cs.writeBytes(languageIter.next());
            cs.writeByte(0);
            cs.write(translatedKeywordIter.next().getBytes("UTF8"));
            cs.writeByte(0);
            String text = textIter.next();
            if (compressed.booleanValue()) {
                cs.write(this.deflate(text.getBytes("UTF8")));
            } else {
                cs.write(text.getBytes("UTF8"));
            }
            cs.finish();
        }
    }

    private void write_zTXt() throws IOException {
        Iterator<String> keywordIter = this.metadata.zTXt_keyword.iterator();
        Iterator<Integer> methodIter = this.metadata.zTXt_compressionMethod.iterator();
        Iterator<String> textIter = this.metadata.zTXt_text.iterator();
        while (keywordIter.hasNext()) {
            ChunkStream cs = new ChunkStream(2052348020, this.stream);
            String keyword = keywordIter.next();
            cs.writeBytes(keyword);
            cs.writeByte(0);
            int compressionMethod = methodIter.next();
            cs.writeByte(compressionMethod);
            String text = textIter.next();
            cs.write(this.deflate(text.getBytes("ISO-8859-1")));
            cs.finish();
        }
    }

    private void writeUnknownChunks() throws IOException {
        Iterator<String> typeIter = this.metadata.unknownChunkType.iterator();
        Iterator<byte[]> dataIter = this.metadata.unknownChunkData.iterator();
        while (typeIter.hasNext() && dataIter.hasNext()) {
            String type = typeIter.next();
            ChunkStream cs = new ChunkStream(PNGImageWriter.chunkType(type), this.stream);
            byte[] data = dataIter.next();
            cs.write(data);
            cs.finish();
        }
    }

    private static int chunkType(String typeString) {
        char c0 = typeString.charAt(0);
        char c1 = typeString.charAt(1);
        char c2 = typeString.charAt(2);
        char c3 = typeString.charAt(3);
        int type = c0 << 24 | c1 << 16 | c2 << 8 | c3;
        return type;
    }

    private void encodePass(ImageOutputStream os, RenderedImage image, int xOffset, int yOffset, int xSkip, int ySkip) throws IOException {
        int minX = this.sourceXOffset;
        int minY = this.sourceYOffset;
        int width = this.sourceWidth;
        int height = this.sourceHeight;
        int hpixels = (width - (xOffset *= this.periodX) + (xSkip *= this.periodX) - 1) / xSkip;
        int vpixels = (height - (yOffset *= this.periodY) + (ySkip *= this.periodY) - 1) / ySkip;
        if (hpixels == 0 || vpixels == 0) {
            return;
        }
        xOffset *= this.numBands;
        xSkip *= this.numBands;
        int samplesPerByte = 8 / this.metadata.IHDR_bitDepth;
        int numSamples = width * this.numBands;
        int[] samples = new int[numSamples];
        int bytesPerRow = hpixels * this.numBands;
        if (this.metadata.IHDR_bitDepth < 8) {
            bytesPerRow = (bytesPerRow + samplesPerByte - 1) / samplesPerByte;
        } else if (this.metadata.IHDR_bitDepth == 16) {
            bytesPerRow *= 2;
        }
        IndexColorModel icm_gray_alpha = null;
        if (this.metadata.IHDR_colorType == 4 && image.getColorModel() instanceof IndexColorModel) {
            bytesPerRow *= 2;
            icm_gray_alpha = (IndexColorModel)image.getColorModel();
        }
        this.currRow = new byte[bytesPerRow + this.bpp];
        this.prevRow = new byte[bytesPerRow + this.bpp];
        this.filteredRows = new byte[5][bytesPerRow + this.bpp];
        int bitDepth = this.metadata.IHDR_bitDepth;
        for (int row = minY + yOffset; row < minY + height; row += ySkip) {
            int[] paletteOrder;
            Rectangle rect = new Rectangle(minX, row, width, 1);
            Raster ras = image.getData(rect);
            if (this.sourceBands != null) {
                ras = ras.createChild(minX, row, width, 1, minX, row, this.sourceBands);
            }
            ras.getPixels(minX, row, width, 1, samples);
            if (image.getColorModel().isAlphaPremultiplied()) {
                WritableRaster wr = ras.createCompatibleWritableRaster();
                wr.setPixels(wr.getMinX(), wr.getMinY(), wr.getWidth(), wr.getHeight(), samples);
                image.getColorModel().coerceData(wr, false);
                wr.getPixels(wr.getMinX(), wr.getMinY(), wr.getWidth(), wr.getHeight(), samples);
            }
            if ((paletteOrder = this.metadata.PLTE_order) != null) {
                for (int i = 0; i < numSamples; ++i) {
                    samples[i] = paletteOrder[samples[i]];
                }
            }
            int count = this.bpp;
            int pos = 0;
            int tmp = 0;
            switch (bitDepth) {
                case 1: 
                case 2: 
                case 4: {
                    int mask = samplesPerByte - 1;
                    for (int s = xOffset; s < numSamples; s += xSkip) {
                        byte val = this.scale0[samples[s]];
                        tmp = tmp << bitDepth | val;
                        if ((pos++ & mask) != mask) continue;
                        this.currRow[count++] = (byte)tmp;
                        tmp = 0;
                        pos = 0;
                    }
                    if ((pos & mask) == 0) break;
                    this.currRow[count++] = (byte)(tmp <<= (8 / bitDepth - pos) * bitDepth);
                    break;
                }
                case 8: {
                    int b;
                    if (this.numBands == 1) {
                        for (int s = xOffset; s < numSamples; s += xSkip) {
                            this.currRow[count++] = this.scale0[samples[s]];
                            if (icm_gray_alpha == null) continue;
                            this.currRow[count++] = this.scale0[icm_gray_alpha.getAlpha(0xFF & samples[s])];
                        }
                    } else {
                        for (int s = xOffset; s < numSamples; s += xSkip) {
                            for (b = 0; b < this.numBands; ++b) {
                                this.currRow[count++] = this.scale[b][samples[s + b]];
                            }
                        }
                    }
                    break;
                }
                case 16: {
                    int b;
                    for (int s = xOffset; s < numSamples; s += xSkip) {
                        for (b = 0; b < this.numBands; ++b) {
                            this.currRow[count++] = this.scaleh[b][samples[s + b]];
                            this.currRow[count++] = this.scalel[b][samples[s + b]];
                        }
                    }
                    break;
                }
            }
            int filterType = this.rowFilter.filterRow(this.metadata.IHDR_colorType, this.currRow, this.prevRow, this.filteredRows, bytesPerRow, this.bpp);
            os.write(filterType);
            os.write(this.filteredRows[filterType], this.bpp, bytesPerRow);
            byte[] swap = this.currRow;
            this.currRow = this.prevRow;
            this.prevRow = swap;
            this.pixelsDone += hpixels;
            this.processImageProgress(100.0f * (float)this.pixelsDone / (float)this.totalPixels);
            if (!this.abortRequested()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write_IDAT(RenderedImage image) throws IOException {
        block5: {
            IDATOutputStream ios = new IDATOutputStream(this.stream, 32768);
            try {
                if (this.metadata.IHDR_interlaceMethod == 1) {
                    for (int i = 0; i < 7; ++i) {
                        this.encodePass(ios, image, PNGImageReader.adam7XOffset[i], PNGImageReader.adam7YOffset[i], PNGImageReader.adam7XSubsampling[i], PNGImageReader.adam7YSubsampling[i]);
                        if (!this.abortRequested()) continue;
                        break block5;
                    }
                    break block5;
                }
                this.encodePass(ios, image, 0, 0, 1, 1);
            }
            finally {
                ios.finish();
            }
        }
    }

    private void writeIEND() throws IOException {
        ChunkStream cs = new ChunkStream(1229278788, this.stream);
        cs.finish();
    }

    private boolean equals(int[] s0, int[] s1) {
        if (s0 == null || s1 == null) {
            return false;
        }
        if (s0.length != s1.length) {
            return false;
        }
        for (int i = 0; i < s0.length; ++i) {
            if (s0[i] == s1[i]) continue;
            return false;
        }
        return true;
    }

    private void initializeScaleTables(int[] sampleSize) {
        int bitDepth = this.metadata.IHDR_bitDepth;
        if (bitDepth == this.scalingBitDepth && this.equals(sampleSize, this.sampleSize)) {
            return;
        }
        this.sampleSize = sampleSize;
        this.scalingBitDepth = bitDepth;
        int maxOutSample = (1 << bitDepth) - 1;
        if (bitDepth <= 8) {
            this.scale = new byte[this.numBands][];
            for (int b = 0; b < this.numBands; ++b) {
                int maxInSample = (1 << sampleSize[b]) - 1;
                int halfMaxInSample = maxInSample / 2;
                this.scale[b] = new byte[maxInSample + 1];
                for (int s = 0; s <= maxInSample; ++s) {
                    this.scale[b][s] = (byte)((s * maxOutSample + halfMaxInSample) / maxInSample);
                }
            }
            this.scale0 = this.scale[0];
            this.scalel = null;
            this.scaleh = this.scalel;
        } else {
            this.scaleh = new byte[this.numBands][];
            this.scalel = new byte[this.numBands][];
            for (int b = 0; b < this.numBands; ++b) {
                int maxInSample = (1 << sampleSize[b]) - 1;
                int halfMaxInSample = maxInSample / 2;
                this.scaleh[b] = new byte[maxInSample + 1];
                this.scalel[b] = new byte[maxInSample + 1];
                for (int s = 0; s <= maxInSample; ++s) {
                    int val = (s * maxOutSample + halfMaxInSample) / maxInSample;
                    this.scaleh[b][s] = (byte)(val >> 8);
                    this.scalel[b][s] = (byte)(val & 0xFF);
                }
            }
            this.scale = null;
            this.scale0 = null;
        }
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (image == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (image.hasRaster()) {
            throw new UnsupportedOperationException("image has a Raster!");
        }
        RenderedImage im = image.getRenderedImage();
        SampleModel sampleModel = im.getSampleModel();
        this.numBands = sampleModel.getNumBands();
        this.sourceXOffset = im.getMinX();
        this.sourceYOffset = im.getMinY();
        this.sourceWidth = im.getWidth();
        this.sourceHeight = im.getHeight();
        this.sourceBands = null;
        this.periodX = 1;
        this.periodY = 1;
        if (param != null) {
            Rectangle sourceRegion = param.getSourceRegion();
            if (sourceRegion != null) {
                Rectangle imageBounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
                sourceRegion = sourceRegion.intersection(imageBounds);
                this.sourceXOffset = sourceRegion.x;
                this.sourceYOffset = sourceRegion.y;
                this.sourceWidth = sourceRegion.width;
                this.sourceHeight = sourceRegion.height;
            }
            int gridX = param.getSubsamplingXOffset();
            int gridY = param.getSubsamplingYOffset();
            this.sourceXOffset += gridX;
            this.sourceYOffset += gridY;
            this.sourceWidth -= gridX;
            this.sourceHeight -= gridY;
            this.periodX = param.getSourceXSubsampling();
            this.periodY = param.getSourceYSubsampling();
            int[] sBands = param.getSourceBands();
            if (sBands != null) {
                this.sourceBands = sBands;
                this.numBands = this.sourceBands.length;
            }
        }
        int destWidth = (this.sourceWidth + this.periodX - 1) / this.periodX;
        int destHeight = (this.sourceHeight + this.periodY - 1) / this.periodY;
        if (destWidth <= 0 || destHeight <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
        this.totalPixels = destWidth * destHeight;
        this.pixelsDone = 0;
        IIOMetadata imd = image.getMetadata();
        this.metadata = imd != null ? (PNGMetadata)this.convertImageMetadata(imd, ImageTypeSpecifier.createFromRenderedImage(im), null) : new PNGMetadata();
        if (param != null) {
            switch (param.getProgressiveMode()) {
                case 1: {
                    this.metadata.IHDR_interlaceMethod = 1;
                    break;
                }
                case 0: {
                    this.metadata.IHDR_interlaceMethod = 0;
                }
            }
        }
        this.metadata.initialize(new ImageTypeSpecifier(im), this.numBands);
        this.metadata.IHDR_width = destWidth;
        this.metadata.IHDR_height = destHeight;
        this.bpp = this.numBands * (this.metadata.IHDR_bitDepth == 16 ? 2 : 1);
        this.initializeScaleTables(sampleModel.getSampleSize());
        this.clearAbortRequest();
        this.processImageStarted(0);
        try {
            this.write_magic();
            this.write_IHDR();
            this.write_cHRM();
            this.write_gAMA();
            this.write_iCCP();
            this.write_sBIT();
            this.write_sRGB();
            this.write_PLTE();
            this.write_hIST();
            this.write_tRNS();
            this.write_bKGD();
            this.write_pHYs();
            this.write_sPLT();
            this.write_tIME();
            this.write_tEXt();
            this.write_iTXt();
            this.write_zTXt();
            this.writeUnknownChunks();
            this.write_IDAT(im);
            if (this.abortRequested()) {
                this.processWriteAborted();
            } else {
                this.writeIEND();
                this.processImageComplete();
            }
        }
        catch (IOException e) {
            throw new IIOException("I/O error writing PNG file!", e);
        }
    }
}

