/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SubjectName;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(X509SubjectNameResolver.class.getName());

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineLookupResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        }
        Element[] x509childNodes = null;
        XMLX509SubjectName[] x509childObject = null;
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.log(Level.FINE, "I can't");
            return null;
        }
        x509childNodes = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SubjectName");
        if (x509childNodes == null || x509childNodes.length <= 0) {
            log.log(Level.FINE, "I can't");
            return null;
        }
        try {
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509SubjectName"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                log.log(Level.INFO, "", ex);
                throw ex;
            }
            x509childObject = new XMLX509SubjectName[x509childNodes.length];
            for (int i = 0; i < x509childNodes.length; ++i) {
                x509childObject[i] = new XMLX509SubjectName(x509childNodes[i], BaseURI);
            }
            while (storage.hasNext()) {
                X509Certificate cert = storage.next();
                XMLX509SubjectName certSN = new XMLX509SubjectName(element.getOwnerDocument(), cert);
                log.log(Level.FINE, "Found Certificate SN: " + certSN.getSubjectName());
                for (int i = 0; i < x509childObject.length; ++i) {
                    log.log(Level.FINE, "Found Element SN:     " + x509childObject[i].getSubjectName());
                    if (certSN.equals(x509childObject[i])) {
                        log.log(Level.FINE, "match !!! ");
                        return cert;
                    }
                    log.log(Level.FINE, "no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            log.log(Level.FINE, "XMLSecurityException", ex);
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

