/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.Closeable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.client.ServiceInterceptor;
import com.sun.xml.internal.ws.api.client.ServiceInterceptorFactory;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.api.pipe.Stubs;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.ClientContainer;
import com.sun.xml.internal.ws.client.HandlerConfigurator;
import com.sun.xml.internal.ws.client.PortInfo;
import com.sun.xml.internal.ws.client.SEIPortInfo;
import com.sun.xml.internal.ws.client.sei.SEIStub;
import com.sun.xml.internal.ws.developer.UsesJAXBContextFeature;
import com.sun.xml.internal.ws.developer.WSBindingProvider;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.RuntimeModeler;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.resources.DispatchMessages;
import com.sun.xml.internal.ws.resources.ProviderApiMessages;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import com.sun.xml.internal.ws.util.ServiceConfigurationError;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.RuntimeWSDLParser;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.AddressingFeature;
import org.xml.sax.SAXException;

public class WSServiceDelegate
extends WSService {
    private final Map<QName, PortInfo> ports = new HashMap<QName, PortInfo>();
    @NotNull
    private HandlerConfigurator handlerConfigurator = new HandlerConfigurator.HandlerResolverImpl(null);
    private final Class<? extends Service> serviceClass;
    @NotNull
    private final QName serviceName;
    private final Map<QName, SEIPortInfo> seiContext = new HashMap<QName, SEIPortInfo>();
    private volatile Executor executor;
    @Nullable
    private WSDLServiceImpl wsdlService;
    private final Container container;
    @NotNull
    final ServiceInterceptor serviceInterceptor;
    private static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];

    Map<QName, PortInfo> getQNameToPortInfoMap() {
        return this.ports;
    }

    public WSServiceDelegate(URL wsdlDocumentLocation, QName serviceName, Class<? extends Service> serviceClass) {
        this(wsdlDocumentLocation == null ? null : new StreamSource(wsdlDocumentLocation.toExternalForm()), serviceName, serviceClass);
    }

    public WSServiceDelegate(@Nullable Source wsdl, @NotNull QName serviceName, final @NotNull Class<? extends Service> serviceClass) {
        HandlerChain handlerChain;
        Container tContainer;
        if (serviceName == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME_NULL(serviceName));
        }
        WSService.InitParams initParams = (WSService.InitParams)INIT_PARAMS.get();
        INIT_PARAMS.set(null);
        if (initParams == null) {
            initParams = EMPTY_PARAMS;
        }
        this.serviceName = serviceName;
        this.serviceClass = serviceClass;
        Container container = tContainer = initParams.getContainer() != null ? initParams.getContainer() : ContainerResolver.getInstance().getContainer();
        if (tContainer == Container.NONE) {
            tContainer = new ClientContainer();
        }
        this.container = tContainer;
        ServiceInterceptor interceptor = ServiceInterceptorFactory.load(this, Thread.currentThread().getContextClassLoader());
        ServiceInterceptor si = this.container.getSPI(ServiceInterceptor.class);
        if (si != null) {
            interceptor = ServiceInterceptor.aggregate(interceptor, si);
        }
        this.serviceInterceptor = interceptor;
        if (wsdl == null && serviceClass != Service.class) {
            WebServiceClient wsClient = AccessController.doPrivileged(new PrivilegedAction<WebServiceClient>(){

                @Override
                public WebServiceClient run() {
                    return serviceClass.getAnnotation(WebServiceClient.class);
                }
            });
            String wsdlLocation = wsClient.wsdlLocation();
            wsdlLocation = JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName(wsdlLocation));
            wsdl = new StreamSource(wsdlLocation);
        }
        WSDLServiceImpl service = null;
        if (wsdl != null) {
            try {
                URL url = wsdl.getSystemId() == null ? null : new URL(wsdl.getSystemId());
                WSDLModelImpl model = this.parseWSDL(url, wsdl);
                service = model.getService(this.serviceName);
                if (service == null) {
                    throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(model.getServices().keySet())));
                }
                for (WSDLPortImpl port : service.getPorts()) {
                    this.ports.put(port.getName(), new PortInfo(this, port));
                }
            }
            catch (MalformedURLException e) {
                throw new WebServiceException(ClientMessages.INVALID_WSDL_URL(wsdl.getSystemId()));
            }
        }
        this.wsdlService = service;
        if (serviceClass != Service.class && (handlerChain = AccessController.doPrivileged(new PrivilegedAction<HandlerChain>(){

            @Override
            public HandlerChain run() {
                return serviceClass.getAnnotation(HandlerChain.class);
            }
        })) != null) {
            this.handlerConfigurator = new HandlerConfigurator.AnnotationConfigurator(this);
        }
    }

    private WSDLModelImpl parseWSDL(URL wsdlDocumentLocation, Source wsdlSource) {
        try {
            return RuntimeWSDLParser.parse(wsdlDocumentLocation, wsdlSource, XmlUtil.createDefaultCatalogResolver(), true, this.getContainer(), ServiceFinder.find(WSDLParserExtension.class).toArray());
        }
        catch (IOException e) {
            throw new WebServiceException(e);
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
        catch (SAXException e) {
            throw new WebServiceException(e);
        }
        catch (ServiceConfigurationError e) {
            throw new WebServiceException(e);
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public HandlerResolver getHandlerResolver() {
        return this.handlerConfigurator.getResolver();
    }

    final HandlerConfigurator getHandlerConfigurator() {
        return this.handlerConfigurator;
    }

    @Override
    public void setHandlerResolver(HandlerResolver resolver) {
        this.handlerConfigurator = new HandlerConfigurator.HandlerResolverImpl(resolver);
    }

    @Override
    public <T> T getPort(QName portName, Class<T> portInterface) throws WebServiceException {
        return this.getPort(portName, portInterface, EMPTY_FEATURES);
    }

    @Override
    public <T> T getPort(QName portName, Class<T> portInterface, WebServiceFeature ... features) {
        if (portName == null || portInterface == null) {
            throw new IllegalArgumentException();
        }
        WSDLServiceImpl tWsdlService = this.wsdlService;
        if (tWsdlService == null && (tWsdlService = this.getWSDLModelfromSEI(portInterface)) == null) {
            throw new WebServiceException(ProviderApiMessages.NO_WSDL_NO_PORT(portInterface.getName()));
        }
        WSDLPortImpl portModel = this.getPortModel(tWsdlService, portName);
        return this.getPort(portModel.getEPR(), portName, portInterface, features);
    }

    @Override
    public <T> T getPort(EndpointReference epr, Class<T> portInterface, WebServiceFeature ... features) {
        return this.getPort(WSEndpointReference.create(epr), portInterface, features);
    }

    @Override
    public <T> T getPort(WSEndpointReference wsepr, Class<T> portInterface, WebServiceFeature ... features) {
        QName portTypeName = RuntimeModeler.getPortTypeName(portInterface);
        QName portName = this.getPortNameFromEPR(wsepr, portTypeName);
        return this.getPort(wsepr, portName, portInterface, features);
    }

    private <T> T getPort(WSEndpointReference wsepr, QName portName, Class<T> portInterface, WebServiceFeature ... features) {
        SEIPortInfo spi = this.addSEI(portName, portInterface, features);
        return this.createEndpointIFBaseProxy(wsepr, portName, portInterface, features, spi);
    }

    @Override
    public <T> T getPort(Class<T> portInterface, WebServiceFeature ... features) {
        QName portTypeName = RuntimeModeler.getPortTypeName(portInterface);
        WSDLServiceImpl wsdlService = this.wsdlService;
        if (wsdlService == null && (wsdlService = this.getWSDLModelfromSEI(portInterface)) == null) {
            throw new WebServiceException(ProviderApiMessages.NO_WSDL_NO_PORT(portInterface.getName()));
        }
        WSDLPortImpl port = wsdlService.getMatchingPort(portTypeName);
        if (port == null) {
            throw new WebServiceException(ClientMessages.UNDEFINED_PORT_TYPE(portTypeName));
        }
        QName portName = port.getName();
        return this.getPort(portName, portInterface, features);
    }

    @Override
    public <T> T getPort(Class<T> portInterface) throws WebServiceException {
        return this.getPort(portInterface, EMPTY_FEATURES);
    }

    @Override
    public void addPort(QName portName, String bindingId, String endpointAddress) throws WebServiceException {
        if (this.ports.containsKey(portName)) {
            throw new WebServiceException(DispatchMessages.DUPLICATE_PORT(portName.toString()));
        }
        BindingID bid = bindingId == null ? BindingID.SOAP11_HTTP : BindingID.parse(bindingId);
        this.ports.put(portName, new PortInfo(this, endpointAddress == null ? null : EndpointAddress.create(endpointAddress), portName, bid));
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName portName, Class<T> aClass, Service.Mode mode) throws WebServiceException {
        return this.createDispatch(portName, aClass, mode, EMPTY_FEATURES);
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName portName, WSEndpointReference wsepr, Class<T> aClass, Service.Mode mode, WebServiceFeature ... features) {
        PortInfo port = this.safeGetPort(portName);
        BindingImpl binding = port.createBinding(features, null);
        binding.setMode(mode);
        Dispatch<T> dispatch = Stubs.createDispatch(port, this, binding, aClass, mode, wsepr);
        this.serviceInterceptor.postCreateDispatch((WSBindingProvider)((Object)dispatch));
        return dispatch;
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName portName, Class<T> aClass, Service.Mode mode, WebServiceFeature ... features) {
        WebServiceFeatureList featureList = new WebServiceFeatureList(features);
        WSEndpointReference wsepr = null;
        if (featureList.isEnabled(AddressingFeature.class) && this.wsdlService != null && this.wsdlService.get(portName) != null) {
            wsepr = this.wsdlService.get(portName).getEPR();
        }
        return this.createDispatch(portName, wsepr, aClass, mode, features);
    }

    @Override
    public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        WSEndpointReference wsepr = new WSEndpointReference(endpointReference);
        QName portName = this.addPortEpr(wsepr);
        return this.createDispatch(portName, wsepr, type, mode, features);
    }

    @NotNull
    public PortInfo safeGetPort(QName portName) {
        PortInfo port = this.ports.get(portName);
        if (port == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(portName, this.buildNameList(this.ports.keySet())));
        }
        return port;
    }

    private StringBuilder buildNameList(Collection<QName> names) {
        StringBuilder sb = new StringBuilder();
        for (QName qn : names) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(qn);
        }
        return sb;
    }

    public EndpointAddress getEndpointAddress(QName qName) {
        return this.ports.get((Object)qName).targetEndpoint;
    }

    @Override
    public Dispatch<Object> createDispatch(QName portName, JAXBContext jaxbContext, Service.Mode mode) throws WebServiceException {
        return this.createDispatch(portName, jaxbContext, mode, EMPTY_FEATURES);
    }

    @Override
    public Dispatch<Object> createDispatch(QName portName, WSEndpointReference wsepr, JAXBContext jaxbContext, Service.Mode mode, WebServiceFeature ... features) {
        PortInfo port = this.safeGetPort(portName);
        BindingImpl binding = port.createBinding(features, null);
        binding.setMode(mode);
        Dispatch<Object> dispatch = Stubs.createJAXBDispatch(port, binding, jaxbContext, mode, wsepr);
        this.serviceInterceptor.postCreateDispatch((WSBindingProvider)((Object)dispatch));
        return dispatch;
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    @Override
    public Dispatch<Object> createDispatch(QName portName, JAXBContext jaxbContext, Service.Mode mode, WebServiceFeature ... webServiceFeatures) {
        WebServiceFeatureList featureList = new WebServiceFeatureList(webServiceFeatures);
        WSEndpointReference wsepr = null;
        if (featureList.isEnabled(AddressingFeature.class) && this.wsdlService != null && this.wsdlService.get(portName) != null) {
            wsepr = this.wsdlService.get(portName).getEPR();
        }
        return this.createDispatch(portName, wsepr, jaxbContext, mode, webServiceFeatures);
    }

    @Override
    public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        WSEndpointReference wsepr = new WSEndpointReference(endpointReference);
        QName portName = this.addPortEpr(wsepr);
        return this.createDispatch(portName, wsepr, context, mode, features);
    }

    private QName addPortEpr(WSEndpointReference wsepr) {
        if (wsepr == null) {
            throw new WebServiceException(ProviderApiMessages.NULL_EPR());
        }
        QName eprPortName = this.getPortNameFromEPR(wsepr, null);
        PortInfo portInfo = new PortInfo(this, wsepr.getAddress() == null ? null : EndpointAddress.create(wsepr.getAddress()), eprPortName, this.getPortModel(this.wsdlService, eprPortName).getBinding().getBindingId());
        if (!this.ports.containsKey(eprPortName)) {
            this.ports.put(eprPortName, portInfo);
        }
        return eprPortName;
    }

    private QName getPortNameFromEPR(@NotNull WSEndpointReference wsepr, @Nullable QName portTypeName) {
        QName portName;
        WSEndpointReference.Metadata metadata = wsepr.getMetaData();
        QName eprServiceName = metadata.getServiceName();
        QName eprPortName = metadata.getPortName();
        if (eprServiceName != null && !eprServiceName.equals(this.serviceName)) {
            throw new WebServiceException("EndpointReference WSDL ServiceName differs from Service Instance WSDL Service QName.\n The two Service QNames must match");
        }
        if (this.wsdlService == null) {
            Source eprWsdlSource = metadata.getWsdlSource();
            if (eprWsdlSource == null) {
                throw new WebServiceException(ProviderApiMessages.NULL_WSDL());
            }
            try {
                WSDLModelImpl eprWsdlMdl = this.parseWSDL(new URL(wsepr.getAddress()), eprWsdlSource);
                this.wsdlService = eprWsdlMdl.getService(this.serviceName);
                if (this.wsdlService == null) {
                    throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(eprWsdlMdl.getServices().keySet())));
                }
            }
            catch (MalformedURLException e) {
                throw new WebServiceException(ClientMessages.INVALID_ADDRESS(wsepr.getAddress()));
            }
        }
        if ((portName = eprPortName) == null && portTypeName != null) {
            WSDLPortImpl port = this.wsdlService.getMatchingPort(portTypeName);
            if (port == null) {
                throw new WebServiceException(ClientMessages.UNDEFINED_PORT_TYPE(portTypeName));
            }
            portName = port.getName();
        }
        if (portName == null) {
            throw new WebServiceException(ProviderApiMessages.NULL_PORTNAME());
        }
        if (this.wsdlService.get(portName) == null) {
            throw new WebServiceException(ClientMessages.INVALID_EPR_PORT_NAME(portName, this.buildWsdlPortNames()));
        }
        return portName;
    }

    private WSDLServiceImpl getWSDLModelfromSEI(final Class sei) {
        WebService ws = AccessController.doPrivileged(new PrivilegedAction<WebService>(){

            @Override
            public WebService run() {
                return sei.getAnnotation(WebService.class);
            }
        });
        if (ws == null || ws.wsdlLocation().equals("")) {
            return null;
        }
        String wsdlLocation = ws.wsdlLocation();
        wsdlLocation = JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName(wsdlLocation));
        StreamSource wsdl = new StreamSource(wsdlLocation);
        WSDLServiceImpl service = null;
        try {
            URL url = wsdl.getSystemId() == null ? null : new URL(wsdl.getSystemId());
            WSDLModelImpl model = this.parseWSDL(url, wsdl);
            service = model.getService(this.serviceName);
            if (service == null) {
                throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(model.getServices().keySet())));
            }
        }
        catch (MalformedURLException e) {
            throw new WebServiceException(ClientMessages.INVALID_WSDL_URL(wsdl.getSystemId()));
        }
        return service;
    }

    @Override
    public QName getServiceName() {
        return this.serviceName;
    }

    protected Class getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public Iterator<QName> getPorts() throws WebServiceException {
        return this.ports.keySet().iterator();
    }

    @Override
    public URL getWSDLDocumentLocation() {
        if (this.wsdlService == null) {
            return null;
        }
        try {
            return new URL(this.wsdlService.getParent().getLocation().getSystemId());
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <T> T createEndpointIFBaseProxy(@Nullable WSEndpointReference epr, QName portName, Class<T> portInterface, WebServiceFeature[] webServiceFeatures, SEIPortInfo eif) {
        if (this.wsdlService == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NO_WSDL(this.serviceName));
        }
        if (this.wsdlService.get(portName) == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(portName, this.buildWsdlPortNames()));
        }
        BindingImpl binding = eif.createBinding(webServiceFeatures, portInterface);
        SEIStub pis = new SEIStub((WSPortInfo)eif, binding, eif.model, epr);
        T proxy = this.createProxy(portInterface, pis);
        if (this.serviceInterceptor != null) {
            this.serviceInterceptor.postCreateProxy((WSBindingProvider)proxy, portInterface);
        }
        return proxy;
    }

    private <T> T createProxy(final Class<T> portInterface, final SEIStub pis) {
        RuntimePermission perm = new RuntimePermission("accessClassInPackage.com.sun.xml.internal.*");
        PermissionCollection perms = perm.newPermissionCollection();
        perms.add(perm);
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                Object proxy = Proxy.newProxyInstance(portInterface.getClassLoader(), new Class[]{portInterface, WSBindingProvider.class, Closeable.class}, pis);
                return portInterface.cast(proxy);
            }
        }, new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)}));
    }

    private StringBuilder buildWsdlPortNames() {
        HashSet<QName> wsdlPortNames = new HashSet<QName>();
        for (WSDLPortImpl port : this.wsdlService.getPorts()) {
            wsdlPortNames.add(port.getName());
        }
        return this.buildNameList(wsdlPortNames);
    }

    @NotNull
    private WSDLPortImpl getPortModel(WSDLServiceImpl wsdlService, QName portName) {
        WSDLPortImpl port = wsdlService.get(portName);
        if (port == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(portName, this.buildWsdlPortNames()));
        }
        return port;
    }

    private SEIPortInfo addSEI(QName portName, Class portInterface, WebServiceFeature ... features) throws WebServiceException {
        boolean ownModel = this.useOwnSEIModel(features);
        if (ownModel) {
            return this.createSEIPortInfo(portName, portInterface, features);
        }
        SEIPortInfo spi = this.seiContext.get(portName);
        if (spi == null) {
            spi = this.createSEIPortInfo(portName, portInterface, features);
            this.seiContext.put(spi.portName, spi);
            this.ports.put(spi.portName, spi);
        }
        return spi;
    }

    private SEIPortInfo createSEIPortInfo(QName portName, Class portInterface, WebServiceFeature ... features) {
        WSDLPortImpl wsdlPort = this.getPortModel(this.wsdlService, portName);
        RuntimeModeler modeler = new RuntimeModeler(portInterface, this.serviceName, wsdlPort, features);
        modeler.setClassLoader(portInterface.getClassLoader());
        modeler.setPortName(portName);
        AbstractSEIModelImpl model = modeler.buildRuntimeModel();
        return new SEIPortInfo(this, portInterface, (SOAPSEIModel)model, wsdlPort);
    }

    private boolean useOwnSEIModel(WebServiceFeature ... features) {
        return WebServiceFeatureList.getFeature(features, UsesJAXBContextFeature.class) != null;
    }

    public WSDLServiceImpl getWsdlService() {
        return this.wsdlService;
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread daemonThread = new Thread(r);
            daemonThread.setDaemon(Boolean.TRUE);
            return daemonThread;
        }
    }
}

