/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.Invokers;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodTypeForm;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import sun.invoke.util.BytecodeDescriptor;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

public final class MethodType
implements Serializable {
    private static final long serialVersionUID = 292L;
    private final Class<?> rtype;
    private final Class<?>[] ptypes;
    private MethodTypeForm form;
    private MethodType wrapAlt;
    private Invokers invokers;
    static final int MAX_JVM_ARITY = 255;
    static final int MAX_MH_ARITY = 254;
    static final int MAX_MH_INVOKER_ARITY = 253;
    static final WeakInternSet internTable = new WeakInternSet();
    static final Class<?>[] NO_PTYPES = new Class[0];
    private static final MethodType[] objectOnlyTypes = new MethodType[20];
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final long rtypeOffset;
    private static final long ptypesOffset;

    private MethodType(Class<?> rtype, Class<?>[] ptypes) {
        MethodType.checkRtype(rtype);
        MethodType.checkPtypes(ptypes);
        this.rtype = rtype;
        this.ptypes = ptypes;
    }

    MethodTypeForm form() {
        return this.form;
    }

    Class<?> rtype() {
        return this.rtype;
    }

    Class<?>[] ptypes() {
        return this.ptypes;
    }

    void setForm(MethodTypeForm f) {
        this.form = f;
    }

    private static void checkRtype(Class<?> rtype) {
        rtype.equals(rtype);
    }

    private static int checkPtype(Class<?> ptype) {
        ptype.getClass();
        if (ptype == Void.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("parameter type cannot be void");
        }
        if (ptype == Double.TYPE || ptype == Long.TYPE) {
            return 1;
        }
        return 0;
    }

    private static int checkPtypes(Class<?>[] ptypes) {
        int slots = 0;
        for (Class<?> ptype : ptypes) {
            slots += MethodType.checkPtype(ptype);
        }
        MethodType.checkSlotCount(ptypes.length + slots);
        return slots;
    }

    static void checkSlotCount(int count) {
        if ((count & 0xFF) != count) {
            throw MethodHandleStatics.newIllegalArgumentException("bad parameter count " + count);
        }
    }

    private static IndexOutOfBoundsException newIndexOutOfBoundsException(Object num) {
        if (num instanceof Integer) {
            num = "bad index: " + num;
        }
        return new IndexOutOfBoundsException(num.toString());
    }

    public static MethodType methodType(Class<?> rtype, Class<?>[] ptypes) {
        return MethodType.makeImpl(rtype, ptypes, false);
    }

    public static MethodType methodType(Class<?> rtype, List<Class<?>> ptypes) {
        boolean notrust = false;
        return MethodType.makeImpl(rtype, MethodType.listToArray(ptypes), notrust);
    }

    private static Class<?>[] listToArray(List<Class<?>> ptypes) {
        MethodType.checkSlotCount(ptypes.size());
        return ptypes.toArray(NO_PTYPES);
    }

    public static MethodType methodType(Class<?> rtype, Class<?> ptype0, Class<?> ... ptypes) {
        Class[] ptypes1 = new Class[1 + ptypes.length];
        ptypes1[0] = ptype0;
        System.arraycopy(ptypes, 0, ptypes1, 1, ptypes.length);
        return MethodType.makeImpl(rtype, ptypes1, true);
    }

    public static MethodType methodType(Class<?> rtype) {
        return MethodType.makeImpl(rtype, NO_PTYPES, true);
    }

    public static MethodType methodType(Class<?> rtype, Class<?> ptype0) {
        return MethodType.makeImpl(rtype, new Class[]{ptype0}, true);
    }

    public static MethodType methodType(Class<?> rtype, MethodType ptypes) {
        return MethodType.makeImpl(rtype, ptypes.ptypes, true);
    }

    static MethodType makeImpl(Class<?> rtype, Class<?>[] ptypes, boolean trusted) {
        MethodTypeForm form;
        MethodType mt1;
        MethodType mt0;
        if (ptypes.length == 0) {
            ptypes = NO_PTYPES;
            trusted = true;
        }
        if ((mt0 = internTable.get(mt1 = new MethodType(rtype, ptypes))) != null) {
            return mt0;
        }
        if (!trusted) {
            mt1 = new MethodType(rtype, (Class[])ptypes.clone());
        }
        mt1.form = form = MethodTypeForm.findForm(mt1);
        return internTable.add(mt1);
    }

    public static MethodType genericMethodType(int objectArgCount, boolean finalArray) {
        MethodType mt;
        MethodType.checkSlotCount(objectArgCount);
        int ivarargs = !finalArray ? 0 : 1;
        int ootIndex = objectArgCount * 2 + ivarargs;
        if (ootIndex < objectOnlyTypes.length && (mt = objectOnlyTypes[ootIndex]) != null) {
            return mt;
        }
        Object[] ptypes = new Class[objectArgCount + ivarargs];
        Arrays.fill(ptypes, Object.class);
        if (ivarargs != 0) {
            ptypes[objectArgCount] = Object[].class;
        }
        mt = MethodType.makeImpl(Object.class, ptypes, true);
        if (ootIndex < objectOnlyTypes.length) {
            MethodType.objectOnlyTypes[ootIndex] = mt;
        }
        return mt;
    }

    public static MethodType genericMethodType(int objectArgCount) {
        return MethodType.genericMethodType(objectArgCount, false);
    }

    public MethodType changeParameterType(int num, Class<?> nptype) {
        if (this.parameterType(num) == nptype) {
            return this;
        }
        MethodType.checkPtype(nptype);
        Class[] nptypes = (Class[])this.ptypes.clone();
        nptypes[num] = nptype;
        return MethodType.makeImpl(this.rtype, nptypes, true);
    }

    public MethodType insertParameterTypes(int num, Class<?> ... ptypesToInsert) {
        int len = this.ptypes.length;
        if (num < 0 || num > len) {
            throw MethodType.newIndexOutOfBoundsException(num);
        }
        int ins = MethodType.checkPtypes(ptypesToInsert);
        MethodType.checkSlotCount(this.parameterSlotCount() + ptypesToInsert.length + ins);
        int ilen = ptypesToInsert.length;
        if (ilen == 0) {
            return this;
        }
        Class<?>[] nptypes = Arrays.copyOfRange(this.ptypes, 0, len + ilen);
        System.arraycopy(nptypes, num, nptypes, num + ilen, len - num);
        System.arraycopy(ptypesToInsert, 0, nptypes, num, ilen);
        return MethodType.makeImpl(this.rtype, nptypes, true);
    }

    public MethodType appendParameterTypes(Class<?> ... ptypesToInsert) {
        return this.insertParameterTypes(this.parameterCount(), ptypesToInsert);
    }

    public MethodType insertParameterTypes(int num, List<Class<?>> ptypesToInsert) {
        return this.insertParameterTypes(num, MethodType.listToArray(ptypesToInsert));
    }

    public MethodType appendParameterTypes(List<Class<?>> ptypesToInsert) {
        return this.insertParameterTypes(this.parameterCount(), ptypesToInsert);
    }

    MethodType replaceParameterTypes(int start, int end, Class<?> ... ptypesToInsert) {
        if (start == end) {
            return this.insertParameterTypes(start, ptypesToInsert);
        }
        int len = this.ptypes.length;
        if (0 > start || start > end || end > len) {
            throw MethodType.newIndexOutOfBoundsException("start=" + start + " end=" + end);
        }
        int ilen = ptypesToInsert.length;
        if (ilen == 0) {
            return this.dropParameterTypes(start, end);
        }
        return this.dropParameterTypes(start, end).insertParameterTypes(start, ptypesToInsert);
    }

    public MethodType dropParameterTypes(int start, int end) {
        Class<?>[] nptypes;
        int len = this.ptypes.length;
        if (0 > start || start > end || end > len) {
            throw MethodType.newIndexOutOfBoundsException("start=" + start + " end=" + end);
        }
        if (start == end) {
            return this;
        }
        if (start == 0) {
            nptypes = end == len ? NO_PTYPES : Arrays.copyOfRange(this.ptypes, end, len);
        } else if (end == len) {
            nptypes = Arrays.copyOfRange(this.ptypes, 0, start);
        } else {
            int tail = len - end;
            nptypes = Arrays.copyOfRange(this.ptypes, 0, start + tail);
            System.arraycopy(this.ptypes, end, nptypes, start, tail);
        }
        return MethodType.makeImpl(this.rtype, nptypes, true);
    }

    public MethodType changeReturnType(Class<?> nrtype) {
        if (this.returnType() == nrtype) {
            return this;
        }
        return MethodType.makeImpl(nrtype, this.ptypes, true);
    }

    public boolean hasPrimitives() {
        return this.form.hasPrimitives();
    }

    public boolean hasWrappers() {
        return this.unwrap() != this;
    }

    public MethodType erase() {
        return this.form.erasedType();
    }

    MethodType basicType() {
        return this.form.basicType();
    }

    MethodType invokerType() {
        return this.insertParameterTypes(0, MethodHandle.class);
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.parameterCount());
    }

    public MethodType wrap() {
        return this.hasPrimitives() ? MethodType.wrapWithPrims(this) : this;
    }

    public MethodType unwrap() {
        MethodType noprims = !this.hasPrimitives() ? this : MethodType.wrapWithPrims(this);
        return MethodType.unwrapWithNoPrims(noprims);
    }

    private static MethodType wrapWithPrims(MethodType pt) {
        assert (pt.hasPrimitives());
        MethodType wt = pt.wrapAlt;
        if (wt == null) {
            wt = MethodTypeForm.canonicalize(pt, 2, 2);
            assert (wt != null);
            pt.wrapAlt = wt;
        }
        return wt;
    }

    private static MethodType unwrapWithNoPrims(MethodType wt) {
        assert (!wt.hasPrimitives());
        MethodType uwt = wt.wrapAlt;
        if (uwt == null) {
            uwt = MethodTypeForm.canonicalize(wt, 3, 3);
            if (uwt == null) {
                uwt = wt;
            }
            wt.wrapAlt = uwt;
        }
        return uwt;
    }

    public Class<?> parameterType(int num) {
        return this.ptypes[num];
    }

    public int parameterCount() {
        return this.ptypes.length;
    }

    public Class<?> returnType() {
        return this.rtype;
    }

    public List<Class<?>> parameterList() {
        return Collections.unmodifiableList(Arrays.asList((Object[])this.ptypes.clone()));
    }

    Class<?> lastParameterType() {
        int len = this.ptypes.length;
        return len == 0 ? Void.TYPE : this.ptypes[len - 1];
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.ptypes.clone();
    }

    public boolean equals(Object x) {
        return this == x || x instanceof MethodType && this.equals((MethodType)x);
    }

    private boolean equals(MethodType that) {
        return this.rtype == that.rtype && Arrays.equals(this.ptypes, that.ptypes);
    }

    public int hashCode() {
        int hashCode = 31 + this.rtype.hashCode();
        for (Class<?> ptype : this.ptypes) {
            hashCode = 31 * hashCode + ptype.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.ptypes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.ptypes[i].getSimpleName());
        }
        sb.append(")");
        sb.append(this.rtype.getSimpleName());
        return sb.toString();
    }

    boolean isViewableAs(MethodType newType) {
        if (!VerifyType.isNullConversion(this.returnType(), newType.returnType())) {
            return false;
        }
        int argc = this.parameterCount();
        if (argc != newType.parameterCount()) {
            return false;
        }
        for (int i = 0; i < argc; ++i) {
            if (VerifyType.isNullConversion(newType.parameterType(i), this.parameterType(i))) continue;
            return false;
        }
        return true;
    }

    boolean isCastableTo(MethodType newType) {
        int argc = this.parameterCount();
        return argc == newType.parameterCount();
    }

    boolean isConvertibleTo(MethodType newType) {
        if (!MethodType.canConvert(this.returnType(), newType.returnType())) {
            return false;
        }
        int argc = this.parameterCount();
        if (argc != newType.parameterCount()) {
            return false;
        }
        for (int i = 0; i < argc; ++i) {
            if (MethodType.canConvert(newType.parameterType(i), this.parameterType(i))) continue;
            return false;
        }
        return true;
    }

    static boolean canConvert(Class<?> src, Class<?> dst) {
        if (src == dst || dst == Object.class) {
            return true;
        }
        if (src.isPrimitive()) {
            if (src == Void.TYPE) {
                return true;
            }
            Wrapper sw = Wrapper.forPrimitiveType(src);
            if (dst.isPrimitive()) {
                return Wrapper.forPrimitiveType(dst).isConvertibleFrom(sw);
            }
            return dst.isAssignableFrom(sw.wrapperType());
        }
        if (dst.isPrimitive()) {
            if (dst == Void.TYPE) {
                return true;
            }
            Wrapper dw = Wrapper.forPrimitiveType(dst);
            if (src.isAssignableFrom(dw.wrapperType())) {
                return true;
            }
            return Wrapper.isWrapperType(src) && dw.isConvertibleFrom(Wrapper.forWrapperType(src));
        }
        return true;
    }

    int parameterSlotCount() {
        return this.form.parameterSlotCount();
    }

    Invokers invokers() {
        Invokers inv = this.invokers;
        if (inv != null) {
            return inv;
        }
        this.invokers = inv = new Invokers(this);
        return inv;
    }

    int parameterSlotDepth(int num) {
        if (num < 0 || num > this.ptypes.length) {
            this.parameterType(num);
        }
        return this.form.parameterToArgSlot(num - 1);
    }

    int returnSlotCount() {
        return this.form.returnSlotCount();
    }

    public static MethodType fromMethodDescriptorString(String descriptor, ClassLoader loader) throws IllegalArgumentException, TypeNotPresentException {
        if (!descriptor.startsWith("(") || descriptor.indexOf(41) < 0 || descriptor.indexOf(46) >= 0) {
            throw new IllegalArgumentException("not a method descriptor: " + descriptor);
        }
        List<Class<?>> types = BytecodeDescriptor.parseMethod(descriptor, loader);
        Class<?> rtype = types.remove(types.size() - 1);
        MethodType.checkSlotCount(types.size());
        Class<?>[] ptypes = MethodType.listToArray(types);
        return MethodType.makeImpl(rtype, ptypes, true);
    }

    public String toMethodDescriptorString() {
        return BytecodeDescriptor.unparse(this);
    }

    static String toFieldDescriptorString(Class<?> cls) {
        return BytecodeDescriptor.unparse(cls);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.returnType());
        s.writeObject(this.parameterArray());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Class returnType = (Class)s.readObject();
        Class[] parameterArray = (Class[])s.readObject();
        MethodType.checkRtype(returnType);
        MethodType.checkPtypes(parameterArray);
        parameterArray = (Class[])parameterArray.clone();
        this.MethodType_init(returnType, parameterArray);
    }

    private MethodType() {
        this.rtype = null;
        this.ptypes = null;
    }

    private void MethodType_init(Class<?> rtype, Class<?>[] ptypes) {
        MethodType.checkRtype(rtype);
        MethodType.checkPtypes(ptypes);
        MethodHandleStatics.UNSAFE.putObject((Object)this, rtypeOffset, rtype);
        MethodHandleStatics.UNSAFE.putObject((Object)this, ptypesOffset, ptypes);
    }

    private Object readResolve() {
        return MethodType.methodType(this.rtype, this.ptypes);
    }

    static {
        try {
            rtypeOffset = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodType.class.getDeclaredField("rtype"));
            ptypesOffset = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodType.class.getDeclaredField("ptypes"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private static class WeakInternSet {
        private static final int DEFAULT_INITIAL_CAPACITY = 16;
        private static final int MAXIMUM_CAPACITY = 0x40000000;
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private Entry[] table;
        private int size;
        private int threshold = 16;
        private final float loadFactor;
        private final ReferenceQueue<Object> queue = new ReferenceQueue();

        private Entry[] newTable(int n) {
            return new Entry[n];
        }

        WeakInternSet() {
            this.loadFactor = 0.75f;
            this.table = this.newTable(16);
        }

        private static int hash(int h) {
            h ^= h >>> 20 ^ h >>> 12;
            return h ^ h >>> 7 ^ h >>> 4;
        }

        private static boolean eq(Object x, Object y) {
            return x == y || x.equals(y);
        }

        private static int indexFor(int h, int length) {
            return h & length - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expungeStaleEntries() {
            Reference<Object> x;
            while ((x = this.queue.poll()) != null) {
                ReferenceQueue<Object> referenceQueue = this.queue;
                synchronized (referenceQueue) {
                    Entry prev;
                    Entry entry = (Entry)x;
                    int i = WeakInternSet.indexFor(entry.hash, this.table.length);
                    Entry p = prev = this.table[i];
                    while (p != null) {
                        Entry next = p.next;
                        if (p == entry) {
                            if (prev == entry) {
                                this.table[i] = next;
                            } else {
                                prev.next = next;
                            }
                            entry.next = null;
                            --this.size;
                            break;
                        }
                        prev = p;
                        p = next;
                    }
                }
            }
        }

        private Entry[] getTable() {
            this.expungeStaleEntries();
            return this.table;
        }

        synchronized MethodType get(MethodType value) {
            int h = WeakInternSet.hash(value.hashCode());
            Entry[] tab = this.getTable();
            int index = WeakInternSet.indexFor(h, tab.length);
            Entry e = tab[index];
            while (e != null) {
                MethodType g;
                if (e.hash == h && WeakInternSet.eq(value, g = (MethodType)e.get())) {
                    return g;
                }
                e = e.next;
            }
            return null;
        }

        synchronized MethodType add(MethodType value) {
            int h = WeakInternSet.hash(value.hashCode());
            Entry[] tab = this.getTable();
            int i = WeakInternSet.indexFor(h, tab.length);
            Entry e = tab[i];
            while (e != null) {
                MethodType g;
                if (h == e.hash && WeakInternSet.eq(value, g = (MethodType)e.get())) {
                    return g;
                }
                e = e.next;
            }
            e = tab[i];
            tab[i] = new Entry(value, this.queue, h, e);
            if (++this.size >= this.threshold) {
                this.resize(tab.length * 2);
            }
            return value;
        }

        private void resize(int newCapacity) {
            Entry[] oldTable = this.getTable();
            int oldCapacity = oldTable.length;
            if (oldCapacity == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            Entry[] newTable = this.newTable(newCapacity);
            this.transfer(oldTable, newTable);
            this.table = newTable;
            if (this.size >= this.threshold / 2) {
                this.threshold = (int)((float)newCapacity * this.loadFactor);
            } else {
                this.expungeStaleEntries();
                this.transfer(newTable, oldTable);
                this.table = oldTable;
            }
        }

        private void transfer(Entry[] src, Entry[] dest) {
            for (int j = 0; j < src.length; ++j) {
                Entry e = src[j];
                src[j] = null;
                while (e != null) {
                    Entry next = e.next;
                    MethodType key = (MethodType)e.get();
                    if (key == null) {
                        e.next = null;
                        --this.size;
                    } else {
                        int i = WeakInternSet.indexFor(e.hash, dest.length);
                        e.next = dest[i];
                        dest[i] = e;
                    }
                    e = next;
                }
            }
        }

        private static class Entry
        extends WeakReference<MethodType> {
            final int hash;
            Entry next;

            Entry(MethodType key, ReferenceQueue<Object> queue, int hash, Entry next) {
                super(key, queue);
                this.hash = hash;
                this.next = next;
            }
        }
    }
}

