/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.net.ProtocolFamily;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import sun.nio.ch.DefaultSelectorProvider;

public abstract class SelectorProvider {
    private static final Object lock = new Object();
    private static SelectorProvider provider = null;

    protected SelectorProvider() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("selectorProvider"));
        }
    }

    private static boolean loadProviderFromProperty() {
        String cn = System.getProperty("java.nio.channels.spi.SelectorProvider");
        if (cn == null) {
            return false;
        }
        try {
            Class<?> c = Class.forName(cn, true, ClassLoader.getSystemClassLoader());
            provider = (SelectorProvider)c.newInstance();
            return true;
        }
        catch (ClassNotFoundException x) {
            throw new ServiceConfigurationError(null, x);
        }
        catch (IllegalAccessException x) {
            throw new ServiceConfigurationError(null, x);
        }
        catch (InstantiationException x) {
            throw new ServiceConfigurationError(null, x);
        }
        catch (SecurityException x) {
            throw new ServiceConfigurationError(null, x);
        }
    }

    private static boolean loadProviderAsService() {
        ServiceLoader<SelectorProvider> sl = ServiceLoader.load(SelectorProvider.class, ClassLoader.getSystemClassLoader());
        Iterator<SelectorProvider> i = sl.iterator();
        while (true) {
            try {
                if (!i.hasNext()) {
                    return false;
                }
                provider = i.next();
                return true;
            }
            catch (ServiceConfigurationError sce) {
                if (sce.getCause() instanceof SecurityException) continue;
                throw sce;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SelectorProvider provider() {
        Object object = lock;
        synchronized (object) {
            if (provider != null) {
                return provider;
            }
            return AccessController.doPrivileged(new PrivilegedAction<SelectorProvider>(){

                @Override
                public SelectorProvider run() {
                    if (SelectorProvider.loadProviderFromProperty()) {
                        return provider;
                    }
                    if (SelectorProvider.loadProviderAsService()) {
                        return provider;
                    }
                    provider = DefaultSelectorProvider.create();
                    return provider;
                }
            });
        }
    }

    public abstract DatagramChannel openDatagramChannel() throws IOException;

    public abstract DatagramChannel openDatagramChannel(ProtocolFamily var1) throws IOException;

    public abstract Pipe openPipe() throws IOException;

    public abstract AbstractSelector openSelector() throws IOException;

    public abstract ServerSocketChannel openServerSocketChannel() throws IOException;

    public abstract SocketChannel openSocketChannel() throws IOException;

    public Channel inheritedChannel() throws IOException {
        return null;
    }
}

