/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.MarshalOutputStream;

public final class MarshalledObject<T>
implements Serializable {
    private byte[] objBytes = null;
    private byte[] locBytes = null;
    private int hash;
    private static final long serialVersionUID = 8988374069173025854L;

    public MarshalledObject(T obj) throws IOException {
        if (obj == null) {
            this.hash = 13;
            return;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ByteArrayOutputStream lout = new ByteArrayOutputStream();
        MarshalledObjectOutputStream out = new MarshalledObjectOutputStream((OutputStream)bout, lout);
        out.writeObject(obj);
        out.flush();
        this.objBytes = bout.toByteArray();
        this.locBytes = out.hadAnnotations() ? lout.toByteArray() : null;
        int h = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            h = 31 * h + this.objBytes[i];
        }
        this.hash = h;
    }

    public T get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.objBytes);
        ByteArrayInputStream lin = this.locBytes == null ? null : new ByteArrayInputStream(this.locBytes);
        MarshalledObjectInputStream in = new MarshalledObjectInputStream(bin, lin);
        Object obj = in.readObject();
        in.close();
        return (T)obj;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof MarshalledObject) {
            MarshalledObject other = (MarshalledObject)obj;
            if (this.objBytes == null || other.objBytes == null) {
                return this.objBytes == other.objBytes;
            }
            if (this.objBytes.length != other.objBytes.length) {
                return false;
            }
            for (int i = 0; i < this.objBytes.length; ++i) {
                if (this.objBytes[i] == other.objBytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class MarshalledObjectInputStream
    extends MarshalInputStream {
        private ObjectInputStream locIn;

        MarshalledObjectInputStream(InputStream objIn, InputStream locIn) throws IOException {
            super(objIn);
            this.locIn = locIn == null ? null : new ObjectInputStream(locIn);
        }

        @Override
        protected Object readLocation() throws IOException, ClassNotFoundException {
            return this.locIn == null ? null : this.locIn.readObject();
        }
    }

    private static class MarshalledObjectOutputStream
    extends MarshalOutputStream {
        private ObjectOutputStream locOut;
        private boolean hadAnnotations;

        MarshalledObjectOutputStream(OutputStream objOut, OutputStream locOut) throws IOException {
            super(objOut);
            this.useProtocolVersion(2);
            this.locOut = new ObjectOutputStream(locOut);
            this.hadAnnotations = false;
        }

        boolean hadAnnotations() {
            return this.hadAnnotations;
        }

        @Override
        protected void writeLocation(String loc) throws IOException {
            this.hadAnnotations |= loc != null;
            this.locOut.writeObject(loc);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.locOut.flush();
        }
    }
}

