/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import sun.security.util.Debug;

public class SubjectDomainCombiner
implements DomainCombiner {
    private Subject subject;
    private WeakKeyValueMap<ProtectionDomain, ProtectionDomain> cachedPDs = new WeakKeyValueMap();
    private Set<Principal> principalSet;
    private Principal[] principals;
    private static final Debug debug = Debug.getInstance("combiner", "\t[SubjectDomainCombiner]");
    private static final boolean useJavaxPolicy = Policy.isCustomPolicySet(debug);
    private static final boolean allowCaching = useJavaxPolicy && SubjectDomainCombiner.cachePolicy();

    public SubjectDomainCombiner(Subject subject) {
        this.subject = subject;
        if (subject.isReadOnly()) {
            this.principalSet = subject.getPrincipals();
            this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
        }
    }

    public Subject getSubject() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("getSubjectFromDomainCombiner"));
        }
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProtectionDomain[] combine(ProtectionDomain[] currentDomains, ProtectionDomain[] assignedDomains) {
        if (debug != null) {
            if (this.subject == null) {
                debug.println("null subject");
            } else {
                final Subject s = this.subject;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        debug.println(s.toString());
                        return null;
                    }
                });
            }
            SubjectDomainCombiner.printInputDomains(currentDomains, assignedDomains);
        }
        if (currentDomains == null || currentDomains.length == 0) {
            return assignedDomains;
        }
        currentDomains = SubjectDomainCombiner.optimize(currentDomains);
        if (debug != null) {
            debug.println("after optimize");
            SubjectDomainCombiner.printInputDomains(currentDomains, assignedDomains);
        }
        if (currentDomains == null && assignedDomains == null) {
            return null;
        }
        if (useJavaxPolicy) {
            return this.combineJavaxPolicy(currentDomains, assignedDomains);
        }
        int cLen = currentDomains == null ? 0 : currentDomains.length;
        int aLen = assignedDomains == null ? 0 : assignedDomains.length;
        ProtectionDomain[] newDomains = new ProtectionDomain[cLen + aLen];
        boolean allNew = true;
        WeakKeyValueMap<ProtectionDomain, ProtectionDomain> weakKeyValueMap = this.cachedPDs;
        synchronized (weakKeyValueMap) {
            if (!this.subject.isReadOnly() && !this.subject.getPrincipals().equals(this.principalSet)) {
                Set<Principal> newSet;
                Set<Principal> set = newSet = this.subject.getPrincipals();
                synchronized (set) {
                    this.principalSet = new HashSet<Principal>(newSet);
                }
                this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            for (int i = 0; i < cLen; ++i) {
                ProtectionDomain pd = currentDomains[i];
                ProtectionDomain subjectPd = this.cachedPDs.getValue(pd);
                if (subjectPd == null) {
                    subjectPd = new ProtectionDomain(pd.getCodeSource(), pd.getPermissions(), pd.getClassLoader(), this.principals);
                    this.cachedPDs.putValue(pd, subjectPd);
                } else {
                    allNew = false;
                }
                newDomains[i] = subjectPd;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            for (int i = 0; i < cLen; ++i) {
                debug.println("\tupdated[" + i + "] = " + SubjectDomainCombiner.printDomain(newDomains[i]));
            }
        }
        if (aLen > 0) {
            System.arraycopy(assignedDomains, 0, newDomains, cLen, aLen);
            if (!allNew) {
                newDomains = SubjectDomainCombiner.optimize(newDomains);
            }
        }
        if (debug != null) {
            if (newDomains == null || newDomains.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                for (int i = 0; i < newDomains.length; ++i) {
                    debug.println("newDomain " + i + ": " + SubjectDomainCombiner.printDomain(newDomains[i]));
                }
            }
        }
        if (newDomains == null || newDomains.length == 0) {
            return null;
        }
        return newDomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain[] combineJavaxPolicy(ProtectionDomain[] currentDomains, ProtectionDomain[] assignedDomains) {
        if (!allowCaching) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Policy.getPolicy().refresh();
                    return null;
                }
            });
        }
        int cLen = currentDomains == null ? 0 : currentDomains.length;
        int aLen = assignedDomains == null ? 0 : assignedDomains.length;
        ProtectionDomain[] newDomains = new ProtectionDomain[cLen + aLen];
        WeakKeyValueMap<ProtectionDomain, ProtectionDomain> weakKeyValueMap = this.cachedPDs;
        synchronized (weakKeyValueMap) {
            if (!this.subject.isReadOnly() && !this.subject.getPrincipals().equals(this.principalSet)) {
                Set<Principal> newSet;
                Set<Principal> set = newSet = this.subject.getPrincipals();
                synchronized (set) {
                    this.principalSet = new HashSet<Principal>(newSet);
                }
                this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            for (int i = 0; i < cLen; ++i) {
                ProtectionDomain pd = currentDomains[i];
                ProtectionDomain subjectPd = this.cachedPDs.getValue(pd);
                if (subjectPd == null) {
                    PermissionCollection newPerms;
                    Enumeration<Permission> e;
                    Permissions perms = new Permissions();
                    PermissionCollection coll = pd.getPermissions();
                    if (coll != null) {
                        PermissionCollection permissionCollection = coll;
                        synchronized (permissionCollection) {
                            e = coll.elements();
                            while (e.hasMoreElements()) {
                                Permission newPerm = e.nextElement();
                                perms.add(newPerm);
                            }
                        }
                    }
                    final CodeSource finalCs = pd.getCodeSource();
                    final Subject finalS = this.subject;
                    PermissionCollection permissionCollection = newPerms = AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

                        @Override
                        public PermissionCollection run() {
                            return Policy.getPolicy().getPermissions(finalS, finalCs);
                        }
                    });
                    synchronized (permissionCollection) {
                        e = newPerms.elements();
                        while (e.hasMoreElements()) {
                            Permission newPerm = e.nextElement();
                            if (perms.implies(newPerm)) continue;
                            perms.add(newPerm);
                            if (debug == null) continue;
                            debug.println("Adding perm " + newPerm + "\n");
                        }
                    }
                    subjectPd = new ProtectionDomain(finalCs, perms, pd.getClassLoader(), this.principals);
                    if (allowCaching) {
                        this.cachedPDs.putValue(pd, subjectPd);
                    }
                }
                newDomains[i] = subjectPd;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            for (int i = 0; i < cLen; ++i) {
                debug.println("\tupdated[" + i + "] = " + newDomains[i]);
            }
        }
        if (aLen > 0) {
            System.arraycopy(assignedDomains, 0, newDomains, cLen, aLen);
        }
        if (debug != null) {
            if (newDomains == null || newDomains.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                for (int i = 0; i < newDomains.length; ++i) {
                    debug.println("newDomain " + i + ": " + newDomains[i].toString());
                }
            }
        }
        if (newDomains == null || newDomains.length == 0) {
            return null;
        }
        return newDomains;
    }

    private static ProtectionDomain[] optimize(ProtectionDomain[] domains) {
        if (domains == null || domains.length == 0) {
            return null;
        }
        ProtectionDomain[] optimized = new ProtectionDomain[domains.length];
        int num = 0;
        for (int i = 0; i < domains.length; ++i) {
            ProtectionDomain pd = domains[i];
            if (pd == null) continue;
            boolean found = false;
            for (int j = 0; j < num && !found; ++j) {
                found = optimized[j] == pd;
            }
            if (found) continue;
            optimized[num++] = pd;
        }
        if (num > 0 && num < domains.length) {
            ProtectionDomain[] downSize = new ProtectionDomain[num];
            System.arraycopy(optimized, 0, downSize, 0, downSize.length);
            optimized = downSize;
        }
        return num == 0 || optimized.length == 0 ? null : optimized;
    }

    private static boolean cachePolicy() {
        String s = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty("cache.auth.policy");
            }
        });
        if (s != null) {
            return Boolean.parseBoolean(s);
        }
        return true;
    }

    private static void printInputDomains(ProtectionDomain[] currentDomains, ProtectionDomain[] assignedDomains) {
        int i;
        if (currentDomains == null || currentDomains.length == 0) {
            debug.println("currentDomains null or 0 length");
        } else {
            for (i = 0; currentDomains != null && i < currentDomains.length; ++i) {
                if (currentDomains[i] == null) {
                    debug.println("currentDomain " + i + ": SystemDomain");
                    continue;
                }
                debug.println("currentDomain " + i + ": " + SubjectDomainCombiner.printDomain(currentDomains[i]));
            }
        }
        if (assignedDomains == null || assignedDomains.length == 0) {
            debug.println("assignedDomains null or 0 length");
        } else {
            debug.println("assignedDomains = ");
            for (i = 0; assignedDomains != null && i < assignedDomains.length; ++i) {
                if (assignedDomains[i] == null) {
                    debug.println("assignedDomain " + i + ": SystemDomain");
                    continue;
                }
                debug.println("assignedDomain " + i + ": " + SubjectDomainCombiner.printDomain(assignedDomains[i]));
            }
        }
    }

    private static String printDomain(final ProtectionDomain pd) {
        if (pd == null) {
            return "null";
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return pd.toString();
            }
        });
    }

    private static class WeakKeyValueMap<K, V>
    extends WeakHashMap<K, WeakReference<V>> {
        private WeakKeyValueMap() {
        }

        public V getValue(K key) {
            WeakReference wr = (WeakReference)super.get(key);
            if (wr != null) {
                return (V)wr.get();
            }
            return null;
        }

        public V putValue(K key, V value) {
            WeakReference<V> wr = super.put(key, new WeakReference<V>(value));
            if (wr != null) {
                return (V)wr.get();
            }
            return null;
        }
    }
}

