/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;

public abstract class MidiMessage
implements Cloneable {
    protected byte[] data;
    protected int length = 0;

    protected MidiMessage(byte[] data) {
        this.data = data;
        if (data != null) {
            this.length = data.length;
        }
    }

    protected void setMessage(byte[] data, int length) throws InvalidMidiDataException {
        if (length < 0 || length > 0 && length > data.length) {
            throw new IndexOutOfBoundsException("length out of bounds: " + length);
        }
        this.length = length;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        System.arraycopy(data, 0, this.data, 0, length);
    }

    public byte[] getMessage() {
        byte[] returnedArray = new byte[this.length];
        System.arraycopy(this.data, 0, returnedArray, 0, this.length);
        return returnedArray;
    }

    public int getStatus() {
        if (this.length > 0) {
            return this.data[0] & 0xFF;
        }
        return 0;
    }

    public int getLength() {
        return this.length;
    }

    public abstract Object clone();
}

