/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;

public class ButtonGroup
implements Serializable {
    protected Vector<AbstractButton> buttons = new Vector();
    ButtonModel selection = null;

    public void add(AbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.addElement(b);
        if (b.isSelected()) {
            if (this.selection == null) {
                this.selection = b.getModel();
            } else {
                b.setSelected(false);
            }
        }
        b.getModel().setGroup(this);
    }

    public void remove(AbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.removeElement(b);
        if (b.getModel() == this.selection) {
            this.selection = null;
        }
        b.getModel().setGroup(null);
    }

    public void clearSelection() {
        if (this.selection != null) {
            ButtonModel oldSelection = this.selection;
            this.selection = null;
            oldSelection.setSelected(false);
        }
    }

    public Enumeration<AbstractButton> getElements() {
        return this.buttons.elements();
    }

    public ButtonModel getSelection() {
        return this.selection;
    }

    public void setSelected(ButtonModel m, boolean b) {
        if (b && m != null && m != this.selection) {
            ButtonModel oldSelection = this.selection;
            this.selection = m;
            if (oldSelection != null) {
                oldSelection.setSelected(false);
            }
            m.setSelected(true);
        }
    }

    public boolean isSelected(ButtonModel m) {
        return m == this.selection;
    }

    public int getButtonCount() {
        if (this.buttons == null) {
            return 0;
        }
        return this.buttons.size();
    }
}

