/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractSpinnerModel;

public class SpinnerDateModel
extends AbstractSpinnerModel
implements Serializable {
    private Comparable start;
    private Comparable end;
    private Calendar value;
    private int calendarField;

    private boolean calendarFieldOK(int calendarField) {
        switch (calendarField) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public SpinnerDateModel(Date value, Comparable start, Comparable end, int calendarField) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (!this.calendarFieldOK(calendarField)) {
            throw new IllegalArgumentException("invalid calendarField");
        }
        if (start != null && start.compareTo(value) > 0 || end != null && end.compareTo(value) < 0) {
            throw new IllegalArgumentException("(start <= value <= end) is false");
        }
        this.value = Calendar.getInstance();
        this.start = start;
        this.end = end;
        this.calendarField = calendarField;
        this.value.setTime(value);
    }

    public SpinnerDateModel() {
        this(new Date(), null, null, 5);
    }

    public void setStart(Comparable start) {
        if (start == null ? this.start != null : !start.equals(this.start)) {
            this.start = start;
            this.fireStateChanged();
        }
    }

    public Comparable getStart() {
        return this.start;
    }

    public void setEnd(Comparable end) {
        if (end == null ? this.end != null : !end.equals(this.end)) {
            this.end = end;
            this.fireStateChanged();
        }
    }

    public Comparable getEnd() {
        return this.end;
    }

    public void setCalendarField(int calendarField) {
        if (!this.calendarFieldOK(calendarField)) {
            throw new IllegalArgumentException("invalid calendarField");
        }
        if (calendarField != this.calendarField) {
            this.calendarField = calendarField;
            this.fireStateChanged();
        }
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    @Override
    public Object getNextValue() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.value.getTime());
        cal.add(this.calendarField, 1);
        Date next = cal.getTime();
        return this.end == null || this.end.compareTo(next) >= 0 ? next : null;
    }

    @Override
    public Object getPreviousValue() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.value.getTime());
        cal.add(this.calendarField, -1);
        Date prev = cal.getTime();
        return this.start == null || this.start.compareTo(prev) <= 0 ? prev : null;
    }

    public Date getDate() {
        return this.value.getTime();
    }

    @Override
    public Object getValue() {
        return this.value.getTime();
    }

    @Override
    public void setValue(Object value) {
        if (value == null || !(value instanceof Date)) {
            throw new IllegalArgumentException("illegal value");
        }
        if (!value.equals(this.value.getTime())) {
            this.value.setTime((Date)value);
            this.fireStateChanged();
        }
    }
}

