/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.filechooser.GenericFileSystemView;
import javax.swing.filechooser.UnixFileSystemView;
import javax.swing.filechooser.WindowsFileSystemView;
import sun.awt.shell.ShellFolder;

public abstract class FileSystemView {
    static FileSystemView windowsFileSystemView = null;
    static FileSystemView unixFileSystemView = null;
    static FileSystemView genericFileSystemView = null;
    private boolean useSystemExtensionHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");

    public static FileSystemView getFileSystemView() {
        if (File.separatorChar == '\\') {
            if (windowsFileSystemView == null) {
                windowsFileSystemView = new WindowsFileSystemView();
            }
            return windowsFileSystemView;
        }
        if (File.separatorChar == '/') {
            if (unixFileSystemView == null) {
                unixFileSystemView = new UnixFileSystemView();
            }
            return unixFileSystemView;
        }
        if (genericFileSystemView == null) {
            genericFileSystemView = new GenericFileSystemView();
        }
        return genericFileSystemView;
    }

    public FileSystemView() {
        final WeakReference<FileSystemView> weakReference = new WeakReference<FileSystemView>(this);
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FileSystemView fileSystemView = (FileSystemView)weakReference.get();
                if (fileSystemView == null) {
                    UIManager.removePropertyChangeListener(this);
                } else if (evt.getPropertyName().equals("lookAndFeel")) {
                    fileSystemView.useSystemExtensionHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");
                }
            }
        });
    }

    public boolean isRoot(File f) {
        File[] roots;
        if (f == null || !f.isAbsolute()) {
            return false;
        }
        for (File root : roots = this.getRoots()) {
            if (!root.equals(f)) continue;
            return true;
        }
        return false;
    }

    public Boolean isTraversable(File f) {
        return f.isDirectory();
    }

    public String getSystemDisplayName(File f) {
        if (f == null) {
            return null;
        }
        String name = f.getName();
        if (!(name.equals("..") || name.equals(".") || !this.useSystemExtensionHiding && this.isFileSystem(f) && !this.isFileSystemRoot(f) || !(f instanceof ShellFolder) && !f.exists())) {
            try {
                name = this.getShellFolder(f).getDisplayName();
            }
            catch (FileNotFoundException e) {
                return null;
            }
            if (name == null || name.length() == 0) {
                name = f.getPath();
            }
        }
        return name;
    }

    public String getSystemTypeDescription(File f) {
        return null;
    }

    public Icon getSystemIcon(File f) {
        ShellFolder sf;
        if (f == null) {
            return null;
        }
        try {
            sf = this.getShellFolder(f);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        Image img = sf.getIcon(false);
        if (img != null) {
            return new ImageIcon(img, sf.getFolderType());
        }
        return UIManager.getIcon(f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
    }

    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        if (folder instanceof ShellFolder) {
            File[] children;
            File parent = file.getParentFile();
            if (parent != null && parent.equals(folder)) {
                return true;
            }
            for (File child : children = this.getFiles(folder, false)) {
                if (!file.equals(child)) continue;
                return true;
            }
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    public File getChild(File parent, String fileName) {
        if (parent instanceof ShellFolder) {
            File[] children;
            for (File child : children = this.getFiles(parent, false)) {
                if (!child.getName().equals(fileName)) continue;
                return child;
            }
        }
        return this.createFileObject(parent, fileName);
    }

    public boolean isFileSystem(File f) {
        if (f instanceof ShellFolder) {
            ShellFolder sf = (ShellFolder)f;
            return sf.isFileSystem() && (!sf.isLink() || !sf.isDirectory());
        }
        return true;
    }

    public abstract File createNewFolder(File var1) throws IOException;

    public boolean isHiddenFile(File f) {
        return f.isHidden();
    }

    public boolean isFileSystemRoot(File dir) {
        return ShellFolder.isFileSystemRoot(dir);
    }

    public boolean isDrive(File dir) {
        return false;
    }

    public boolean isFloppyDrive(File dir) {
        return false;
    }

    public boolean isComputerNode(File dir) {
        return ShellFolder.isComputerNode(dir);
    }

    public File[] getRoots() {
        File[] roots = (File[])ShellFolder.get("roots");
        for (int i = 0; i < roots.length; ++i) {
            if (!this.isFileSystemRoot(roots[i])) continue;
            roots[i] = this.createFileSystemRoot(roots[i]);
        }
        return roots;
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getDefaultDirectory() {
        File f = (File)ShellFolder.get("fileChooserDefaultFolder");
        if (this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        return f;
    }

    public File createFileObject(File dir, String filename) {
        if (dir == null) {
            return new File(filename);
        }
        return new File(dir, filename);
    }

    public File createFileObject(String path) {
        File f = new File(path);
        if (this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        return f;
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        File[] names;
        ArrayList<File> files = new ArrayList<File>();
        if (!(dir instanceof ShellFolder)) {
            try {
                dir = this.getShellFolder(dir);
            }
            catch (FileNotFoundException e) {
                return new File[0];
            }
        }
        if ((names = ((ShellFolder)dir).listFiles(!useFileHiding)) == null) {
            return new File[0];
        }
        for (File f : names) {
            if (Thread.currentThread().isInterrupted()) break;
            if (!(f instanceof ShellFolder)) {
                if (this.isFileSystemRoot(f)) {
                    f = this.createFileSystemRoot(f);
                }
                try {
                    f = ShellFolder.getShellFolder(f);
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                catch (InternalError e) {
                    continue;
                }
            }
            if (useFileHiding && this.isHiddenFile(f)) continue;
            files.add(f);
        }
        return files.toArray(new File[files.size()]);
    }

    public File getParentDirectory(File dir) {
        ShellFolder sf;
        if (dir == null || !dir.exists()) {
            return null;
        }
        try {
            sf = this.getShellFolder(dir);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        File psf = sf.getParentFile();
        if (psf == null) {
            return null;
        }
        if (this.isFileSystem(psf)) {
            File ppsf;
            File f = psf;
            if (!(f.exists() || (ppsf = psf.getParentFile()) != null && this.isFileSystem(ppsf))) {
                f = this.createFileSystemRoot(f);
            }
            return f;
        }
        return psf;
    }

    ShellFolder getShellFolder(File f) throws FileNotFoundException {
        if (!(f instanceof ShellFolder) && !(f instanceof FileSystemRoot) && this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        try {
            return ShellFolder.getShellFolder(f);
        }
        catch (InternalError e) {
            System.err.println("FileSystemView.getShellFolder: f=" + f);
            e.printStackTrace();
            return null;
        }
    }

    protected File createFileSystemRoot(File f) {
        return new FileSystemRoot(f);
    }

    static class FileSystemRoot
    extends File {
        public FileSystemRoot(File f) {
            super(f, "");
        }

        public FileSystemRoot(String s) {
            super(s);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public String getName() {
            return this.getPath();
        }
    }
}

