/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    protected Vector<TableColumn> tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;

    public DefaultTableColumnModel() {
        this.tableColumns = new Vector();
        this.setSelectionModel(this.createSelectionModel());
        this.setColumnMargin(1);
        this.invalidateWidthCache();
        this.setColumnSelectionAllowed(false);
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        if (aColumn == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.tableColumns.addElement(aColumn);
        aColumn.addPropertyChangeListener(this);
        this.invalidateWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
    }

    @Override
    public void removeColumn(TableColumn column) {
        int columnIndex = this.tableColumns.indexOf(column);
        if (columnIndex != -1) {
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(columnIndex, columnIndex);
            }
            column.removePropertyChangeListener(this);
            this.tableColumns.removeElementAt(columnIndex);
            this.invalidateWidthCache();
            this.fireColumnRemoved(new TableColumnModelEvent(this, columnIndex, 0));
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        if (columnIndex == newIndex) {
            this.fireColumnMoved(new TableColumnModelEvent(this, columnIndex, newIndex));
            return;
        }
        TableColumn aColumn = this.tableColumns.elementAt(columnIndex);
        this.tableColumns.removeElementAt(columnIndex);
        boolean selected = this.selectionModel.isSelectedIndex(columnIndex);
        this.selectionModel.removeIndexInterval(columnIndex, columnIndex);
        this.tableColumns.insertElementAt(aColumn, newIndex);
        this.selectionModel.insertIndexInterval(newIndex, 1, true);
        if (selected) {
            this.selectionModel.addSelectionInterval(newIndex, newIndex);
        } else {
            this.selectionModel.removeSelectionInterval(newIndex, newIndex);
        }
        this.fireColumnMoved(new TableColumnModelEvent(this, columnIndex, newIndex));
    }

    @Override
    public void setColumnMargin(int newMargin) {
        if (newMargin != this.columnMargin) {
            this.columnMargin = newMargin;
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return this.tableColumns.elements();
    }

    @Override
    public int getColumnIndex(Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Enumeration<TableColumn> enumeration = this.getColumns();
        int index = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            if (identifier.equals(aColumn.getIdentifier())) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    @Override
    public TableColumn getColumn(int columnIndex) {
        return this.tableColumns.elementAt(columnIndex);
    }

    @Override
    public int getColumnMargin() {
        return this.columnMargin;
    }

    @Override
    public int getColumnIndexAtX(int x) {
        if (x < 0) {
            return -1;
        }
        int cc = this.getColumnCount();
        for (int column = 0; column < cc; ++column) {
            if ((x -= this.getColumn(column).getWidth()) >= 0) continue;
            return column;
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel oldModel = this.selectionModel;
        if (newModel != oldModel) {
            if (oldModel != null) {
                oldModel.removeListSelectionListener(this);
            }
            this.selectionModel = newModel;
            newModel.addListSelectionListener(this);
        }
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void setColumnSelectionAllowed(boolean flag) {
        this.columnSelectionAllowed = flag;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    @Override
    public int[] getSelectedColumns() {
        if (this.selectionModel != null) {
            int iMin = this.selectionModel.getMinSelectionIndex();
            int iMax = this.selectionModel.getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                return new int[0];
            }
            int[] rvTmp = new int[1 + (iMax - iMin)];
            int n = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                rvTmp[n++] = i;
            }
            int[] rv = new int[n];
            System.arraycopy(rvTmp, 0, rv, 0, n);
            return rv;
        }
        return new int[0];
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.selectionModel != null) {
            int iMin = this.selectionModel.getMinSelectionIndex();
            int iMax = this.selectionModel.getMaxSelectionIndex();
            int count = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener x) {
        this.listenerList.add(TableColumnModelListener.class, x);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener x) {
        this.listenerList.remove(TableColumnModelListener.class, x);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        return (TableColumnModelListener[])this.listenerList.getListeners(TableColumnModelListener.class);
    }

    protected void fireColumnAdded(TableColumnModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnAdded(e);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnRemoved(e);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnMoved(e);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnSelectionChanged(e);
        }
    }

    protected void fireColumnMarginChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((TableColumnModelListener)listeners[i + 1]).columnMarginChanged(this.changeEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name == "width" || name == "preferredWidth") {
            this.invalidateWidthCache();
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.fireColumnSelectionChanged(e);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void recalcWidthCache() {
        Enumeration<TableColumn> enumeration = this.getColumns();
        this.totalColumnWidth = 0;
        while (enumeration.hasMoreElements()) {
            this.totalColumnWidth += enumeration.nextElement().getWidth();
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }
}

