/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.IllegalComponentStateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import sun.awt.DisplayChangedListener;
import sun.util.logging.PlatformLogger;

public class SunDisplayChanger {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.multiscreen.SunDisplayChanger");
    private Map listeners = Collections.synchronizedMap(new WeakHashMap(1));

    public void add(DisplayChangedListener theListener) {
        if (log.isLoggable(500) && theListener == null) {
            log.fine("Assertion (theListener != null) failed");
        }
        if (log.isLoggable(400)) {
            log.finer("Adding listener: " + theListener);
        }
        this.listeners.put(theListener, null);
    }

    public void remove(DisplayChangedListener theListener) {
        if (log.isLoggable(500) && theListener == null) {
            log.fine("Assertion (theListener != null) failed");
        }
        if (log.isLoggable(400)) {
            log.finer("Removing listener: " + theListener);
        }
        this.listeners.remove(theListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        HashMap listClone;
        if (log.isLoggable(300)) {
            log.finest("notifyListeners");
        }
        Map map = this.listeners;
        synchronized (map) {
            listClone = new HashMap(this.listeners);
        }
        Set cloneSet = listClone.keySet();
        for (DisplayChangedListener current : cloneSet) {
            try {
                if (log.isLoggable(300)) {
                    log.finest("displayChanged for listener: " + current);
                }
                current.displayChanged();
            }
            catch (IllegalComponentStateException e) {
                this.listeners.remove(current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPaletteChanged() {
        HashMap listClone;
        if (log.isLoggable(300)) {
            log.finest("notifyPaletteChanged");
        }
        Map map = this.listeners;
        synchronized (map) {
            listClone = new HashMap(this.listeners);
        }
        Set cloneSet = listClone.keySet();
        for (DisplayChangedListener current : cloneSet) {
            try {
                if (log.isLoggable(300)) {
                    log.finest("paletteChanged for listener: " + current);
                }
                current.paletteChanged();
            }
            catch (IllegalComponentStateException e) {
                this.listeners.remove(current);
            }
        }
    }
}

