/*
 * Decompiled with CFR 0.152.
 */
package sun.instrument;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;

public class TransformerManager {
    private TransformerInfo[] mTransformerList = new TransformerInfo[0];
    private boolean mIsRetransformable;

    TransformerManager(boolean isRetransformable) {
        this.mIsRetransformable = isRetransformable;
    }

    boolean isRetransformable() {
        return this.mIsRetransformable;
    }

    public synchronized void addTransformer(ClassFileTransformer transformer) {
        TransformerInfo[] oldList = this.mTransformerList;
        TransformerInfo[] newList = new TransformerInfo[oldList.length + 1];
        System.arraycopy(oldList, 0, newList, 0, oldList.length);
        newList[oldList.length] = new TransformerInfo(transformer);
        this.mTransformerList = newList;
    }

    public synchronized boolean removeTransformer(ClassFileTransformer transformer) {
        boolean found = false;
        TransformerInfo[] oldList = this.mTransformerList;
        int oldLength = oldList.length;
        int newLength = oldLength - 1;
        int matchingIndex = 0;
        for (int x = oldLength - 1; x >= 0; --x) {
            if (oldList[x].transformer() != transformer) continue;
            found = true;
            matchingIndex = x;
            break;
        }
        if (found) {
            TransformerInfo[] newList = new TransformerInfo[newLength];
            if (matchingIndex > 0) {
                System.arraycopy(oldList, 0, newList, 0, matchingIndex);
            }
            if (matchingIndex < newLength) {
                System.arraycopy(oldList, matchingIndex + 1, newList, matchingIndex, newLength - matchingIndex);
            }
            this.mTransformerList = newList;
        }
        return found;
    }

    synchronized boolean includesTransformer(ClassFileTransformer transformer) {
        for (TransformerInfo info : this.mTransformerList) {
            if (info.transformer() != transformer) continue;
            return true;
        }
        return false;
    }

    private TransformerInfo[] getSnapshotTransformerList() {
        return this.mTransformerList;
    }

    public byte[] transform(ClassLoader loader, String classname, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        boolean someoneTouchedTheBytecode = false;
        TransformerInfo[] transformerList = this.getSnapshotTransformerList();
        byte[] bufferToUse = classfileBuffer;
        for (int x = 0; x < transformerList.length; ++x) {
            TransformerInfo transformerInfo = transformerList[x];
            ClassFileTransformer transformer = transformerInfo.transformer();
            byte[] transformedBytes = null;
            try {
                transformedBytes = transformer.transform(loader, classname, classBeingRedefined, protectionDomain, bufferToUse);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (transformedBytes == null) continue;
            someoneTouchedTheBytecode = true;
            bufferToUse = transformedBytes;
        }
        Object result = someoneTouchedTheBytecode ? bufferToUse : null;
        return result;
    }

    int getTransformerCount() {
        TransformerInfo[] transformerList = this.getSnapshotTransformerList();
        return transformerList.length;
    }

    boolean setNativeMethodPrefix(ClassFileTransformer transformer, String prefix) {
        TransformerInfo[] transformerList = this.getSnapshotTransformerList();
        for (int x = 0; x < transformerList.length; ++x) {
            TransformerInfo transformerInfo = transformerList[x];
            ClassFileTransformer aTransformer = transformerInfo.transformer();
            if (aTransformer != transformer) continue;
            transformerInfo.setPrefix(prefix);
            return true;
        }
        return false;
    }

    String[] getNativeMethodPrefixes() {
        TransformerInfo[] transformerList = this.getSnapshotTransformerList();
        String[] prefixes = new String[transformerList.length];
        for (int x = 0; x < transformerList.length; ++x) {
            TransformerInfo transformerInfo = transformerList[x];
            prefixes[x] = transformerInfo.getPrefix();
        }
        return prefixes;
    }

    private class TransformerInfo {
        final ClassFileTransformer mTransformer;
        String mPrefix;

        TransformerInfo(ClassFileTransformer transformer) {
            this.mTransformer = transformer;
            this.mPrefix = null;
        }

        ClassFileTransformer transformer() {
            return this.mTransformer;
        }

        String getPrefix() {
            return this.mPrefix;
        }

        void setPrefix(String prefix) {
            this.mPrefix = prefix;
        }
    }
}

