/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.LockInfo;
import java.lang.management.ThreadInfo;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.Attribute;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import sun.management.LockDataConverterMXBean;

class LockDataConverter
extends StandardMBean
implements LockDataConverterMXBean {
    private LockInfo lockInfo;
    private LockInfo[] lockedSyncs;

    private LockDataConverter() {
        super(LockDataConverterMXBean.class, true);
        this.lockInfo = null;
        this.lockedSyncs = null;
    }

    private LockDataConverter(ThreadInfo ti) {
        super(LockDataConverterMXBean.class, true);
        this.lockInfo = ti.getLockInfo();
        this.lockedSyncs = ti.getLockedSynchronizers();
    }

    @Override
    public void setLockInfo(LockInfo l) {
        this.lockInfo = l;
    }

    @Override
    public LockInfo getLockInfo() {
        return this.lockInfo;
    }

    @Override
    public void setLockedSynchronizers(LockInfo[] l) {
        this.lockedSyncs = l;
    }

    @Override
    public LockInfo[] getLockedSynchronizers() {
        return this.lockedSyncs;
    }

    CompositeData toLockInfoCompositeData() {
        try {
            return (CompositeData)this.getAttribute("LockInfo");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    CompositeData[] toLockedSynchronizersCompositeData() {
        try {
            return (CompositeData[])this.getAttribute("LockedSynchronizers");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    LockInfo toLockInfo(CompositeData cd) {
        try {
            this.setAttribute(new Attribute("LockInfo", cd));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return this.getLockInfo();
    }

    LockInfo[] toLockedSynchronizers(CompositeData[] cd) {
        try {
            this.setAttribute(new Attribute("LockedSynchronizers", cd));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return this.getLockedSynchronizers();
    }

    static CompositeData toLockInfoCompositeData(LockInfo l) {
        LockDataConverter ldc = LockDataConverter.newLockDataConverter();
        ldc.setLockInfo(l);
        return ldc.toLockInfoCompositeData();
    }

    static LockDataConverter newLockDataConverter() {
        return AccessController.doPrivileged(new PrivilegedAction<LockDataConverter>(){

            @Override
            public LockDataConverter run() {
                return new LockDataConverter();
            }
        });
    }

    static LockDataConverter newLockDataConverter(ThreadInfo ti) {
        LockDataConverter result = LockDataConverter.newLockDataConverter();
        result.lockInfo = ti.getLockInfo();
        result.lockedSyncs = ti.getLockedSynchronizers();
        return result;
    }
}

