/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.Authenticator;
import java.net.URL;
import java.util.HashMap;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.Negotiator;
import sun.util.logging.PlatformLogger;

class NegotiateAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private static final PlatformLogger logger = HttpURLConnection.getHttpLogger();
    private final HttpCallerInfo hci;
    static HashMap<String, Boolean> supported = null;
    static HashMap<String, Negotiator> cache = null;
    private Negotiator negotiator = null;

    public NegotiateAuthentication(HttpCallerInfo hci) {
        super(Authenticator.RequestorType.PROXY == hci.authType ? (char)'p' : 's', hci.scheme.equalsIgnoreCase("Negotiate") ? AuthScheme.NEGOTIATE : AuthScheme.KERBEROS, hci.url, "");
        this.hci = hci;
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSupported(HttpCallerInfo hci) {
        ClassLoader loader;
        block6: {
            loader = null;
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException se) {
                if (!logger.isLoggable(PlatformLogger.Level.FINER)) break block6;
                logger.finer("NegotiateAuthentication: Attempt to get the context class loader failed - " + se);
            }
        }
        if (loader != null) {
            ClassLoader classLoader = loader;
            synchronized (classLoader) {
                return NegotiateAuthentication.isSupportedImpl(hci);
            }
        }
        return NegotiateAuthentication.isSupportedImpl(hci);
    }

    private static synchronized boolean isSupportedImpl(HttpCallerInfo hci) {
        if (supported == null) {
            supported = new HashMap();
            cache = new HashMap();
        }
        String hostname = hci.host;
        if (supported.containsKey(hostname = hostname.toLowerCase())) {
            return supported.get(hostname);
        }
        Negotiator neg = Negotiator.getNegotiator(hci);
        if (neg != null) {
            supported.put(hostname, true);
            cache.put(hostname, neg);
            return true;
        }
        supported.put(hostname, false);
        return false;
    }

    @Override
    public String getHeaderValue(URL url, String method) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    public boolean isAuthorizationStale(String header) {
        return false;
    }

    @Override
    public synchronized boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        try {
            byte[] incoming = null;
            String[] parts = raw.split("\\s+");
            if (parts.length > 1) {
                incoming = new BASE64Decoder().decodeBuffer(parts[1]);
            }
            String response = this.hci.scheme + " " + new B64Encoder().encode(incoming == null ? this.firstToken() : this.nextToken(incoming));
            conn.setAuthenticationProperty(this.getHeaderName(), response);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] firstToken() throws IOException {
        this.negotiator = null;
        if (cache != null) {
            HashMap<String, Negotiator> hashMap = cache;
            synchronized (hashMap) {
                this.negotiator = cache.get(this.getHost());
                if (this.negotiator != null) {
                    cache.remove(this.getHost());
                }
            }
        }
        if (this.negotiator == null) {
            this.negotiator = Negotiator.getNegotiator(this.hci);
            if (this.negotiator == null) {
                IOException ioe = new IOException("Cannot initialize Negotiator");
                throw ioe;
            }
        }
        return this.negotiator.firstToken();
    }

    private byte[] nextToken(byte[] token) throws IOException {
        return this.negotiator.nextToken(token);
    }

    class B64Encoder
    extends BASE64Encoder {
        B64Encoder() {
        }

        @Override
        protected int bytesPerLine() {
            return 100000;
        }
    }
}

