/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AllocatedNativeObject;

abstract class AbstractPollArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLOUT = 4;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    protected AllocatedNativeObject pollArray;
    protected int totalChannels = 0;
    protected long pollArrayAddress;

    AbstractPollArrayWrapper() {
    }

    int getEventOps(int i) {
        int offset = 8 * i + 4;
        return this.pollArray.getShort(offset);
    }

    int getReventOps(int i) {
        int offset = 8 * i + 6;
        return this.pollArray.getShort(offset);
    }

    int getDescriptor(int i) {
        int offset = 8 * i + 0;
        return this.pollArray.getInt(offset);
    }

    void putEventOps(int i, int event) {
        int offset = 8 * i + 4;
        this.pollArray.putShort(offset, (short)event);
    }

    void putReventOps(int i, int revent) {
        int offset = 8 * i + 6;
        this.pollArray.putShort(offset, (short)revent);
    }

    void putDescriptor(int i, int fd) {
        int offset = 8 * i + 0;
        this.pollArray.putInt(offset, fd);
    }
}

