/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.spi.AsynchronousChannelProvider;
import java.security.AccessController;
import sun.nio.ch.AixAsynchronousChannelProvider;
import sun.nio.ch.BsdAsynchronousChannelProvider;
import sun.nio.ch.LinuxAsynchronousChannelProvider;
import sun.nio.ch.SolarisAsynchronousChannelProvider;
import sun.security.action.GetPropertyAction;

public class DefaultAsynchronousChannelProvider {
    private DefaultAsynchronousChannelProvider() {
    }

    public static AsynchronousChannelProvider create() {
        String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (osname.equals("SunOS")) {
            return new SolarisAsynchronousChannelProvider();
        }
        if (osname.equals("Linux")) {
            return new LinuxAsynchronousChannelProvider();
        }
        if (osname.contains("OS X")) {
            return new BsdAsynchronousChannelProvider();
        }
        if (osname.equals("AIX")) {
            return new AixAsynchronousChannelProvider();
        }
        throw new InternalError("platform not recognized");
    }
}

