/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.rmi.runtime.Log;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;

class HttpInputStream
extends FilterInputStream {
    protected int bytesLeft;
    protected int bytesLeftAtMark;

    public HttpInputStream(InputStream in) throws IOException {
        super(in);
        String line;
        if (in.markSupported()) {
            in.mark(0);
        }
        DataInputStream dis = new DataInputStream(in);
        String key = "Content-length:".toLowerCase();
        boolean contentLengthFound = false;
        do {
            line = dis.readLine();
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
                RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "received header line: \"" + line + "\"");
            }
            if (line == null) {
                throw new EOFException();
            }
            if (!line.toLowerCase().startsWith(key)) continue;
            if (contentLengthFound) {
                throw new IOException("Multiple Content-length entries found.");
            }
            this.bytesLeft = Integer.parseInt(line.substring(key.length()).trim());
            contentLengthFound = true;
        } while (line.length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n');
        if (!contentLengthFound || this.bytesLeft < 0) {
            this.bytesLeft = Integer.MAX_VALUE;
        }
        this.bytesLeftAtMark = this.bytesLeft;
        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "content length: " + this.bytesLeft);
        }
    }

    @Override
    public int available() throws IOException {
        int bytesAvailable = this.in.available();
        if (bytesAvailable > this.bytesLeft) {
            bytesAvailable = this.bytesLeft;
        }
        return bytesAvailable;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeft > 0) {
            int data = this.in.read();
            if (data != -1) {
                --this.bytesLeft;
            }
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
                RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "received byte: '" + ((data & 0x7F) < 32 ? " " : String.valueOf((char)data)) + "' " + data);
            }
            return data;
        }
        RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "read past content length");
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesLeft == 0 && len > 0) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "read past content length");
            return -1;
        }
        if (len > this.bytesLeft) {
            len = this.bytesLeft;
        }
        int bytesRead = this.in.read(b, off, len);
        this.bytesLeft -= bytesRead;
        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "read " + bytesRead + " bytes, " + this.bytesLeft + " remaining");
        }
        return bytesRead;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        if (this.in.markSupported()) {
            this.bytesLeftAtMark = this.bytesLeft;
        }
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.bytesLeft = this.bytesLeftAtMark;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > (long)this.bytesLeft) {
            n = this.bytesLeft;
        }
        long bytesSkipped = this.in.skip(n);
        this.bytesLeft = (int)((long)this.bytesLeft - bytesSkipped);
        return bytesSkipped;
    }
}

