/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.proxy.RMIDirectSocketFactory;
import sun.rmi.transport.proxy.RMIHttpToCGISocketFactory;
import sun.rmi.transport.proxy.RMIHttpToPortSocketFactory;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

public class RMIMasterSocketFactory
extends RMISocketFactory {
    static int logLevel = LogStream.parseLevel(RMIMasterSocketFactory.getLogLevel());
    static final Log proxyLog = Log.getLog("sun.rmi.transport.tcp.proxy", "transport", logLevel);
    private static long connectTimeout = RMIMasterSocketFactory.getConnectTimeout();
    private static final boolean eagerHttpFallback = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.transport.proxy.eagerHttpFallback"));
    private Hashtable<String, RMISocketFactory> successTable = new Hashtable();
    private static final int MaxRememberedHosts = 64;
    private Vector<String> hostList = new Vector(64);
    protected RMISocketFactory initialFactory = new RMIDirectSocketFactory();
    protected Vector<RMISocketFactory> altFactoryList = new Vector(2);

    private static String getLogLevel() {
        return AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.proxy.logLevel"));
    }

    private static long getConnectTimeout() {
        return AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.proxy.connectTimeout", 15000L));
    }

    public RMIMasterSocketFactory() {
        boolean setFactories = false;
        try {
            Boolean tmp;
            String proxyHost = AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
            if (proxyHost == null) {
                proxyHost = AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
            }
            if (!(tmp = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.disableHttp"))).booleanValue() && proxyHost != null && proxyHost.length() > 0) {
                setFactories = true;
            }
        }
        catch (Exception e) {
            setFactories = true;
        }
        if (setFactories) {
            this.altFactoryList.addElement(new RMIHttpToPortSocketFactory());
            this.altFactoryList.addElement(new RMIHttpToCGISocketFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        if (proxyLog.isLoggable(Log.BRIEF)) {
            proxyLog.log(Log.BRIEF, "host: " + host + ", port: " + port);
        }
        if (this.altFactoryList.size() == 0) {
            return this.initialFactory.createSocket(host, port);
        }
        RMISocketFactory factory = this.successTable.get(host);
        if (factory != null) {
            if (!proxyLog.isLoggable(Log.BRIEF)) return factory.createSocket(host, port);
            proxyLog.log(Log.BRIEF, "previously successful factory found: " + factory);
            return factory.createSocket(host, port);
        }
        Socket initialSocket = null;
        Socket fallbackSocket = null;
        AsyncConnector connector = new AsyncConnector(this.initialFactory, host, port, AccessController.getContext());
        IOException initialFailure = null;
        try {
            Object object = connector;
            // MONITORENTER : object
            Thread t = AccessController.doPrivileged(new NewThreadAction(connector, "AsyncConnector", true));
            t.start();
            try {
                long now = System.currentTimeMillis();
                long deadline = now + connectTimeout;
                do {
                    connector.wait(deadline - now);
                } while ((initialSocket = this.checkConnector(connector)) == null && (now = System.currentTimeMillis()) < deadline);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("interrupted while waiting for connector");
            }
            if (initialSocket == null) {
                throw new NoRouteToHostException("connect timed out: " + host);
            }
            proxyLog.log(Log.BRIEF, "direct socket connection successful");
            object = initialSocket;
            return object;
        }
        catch (NoRouteToHostException | UnknownHostException e) {
            initialFailure = e;
        }
        catch (SocketException e) {
            if (!eagerHttpFallback) throw e;
            initialFailure = e;
        }
        finally {
            if (initialFailure != null) {
                if (proxyLog.isLoggable(Log.BRIEF)) {
                    proxyLog.log(Log.BRIEF, "direct socket connection failed: ", initialFailure);
                }
                for (int i = 0; i < this.altFactoryList.size(); ++i) {
                    factory = this.altFactoryList.elementAt(i);
                    if (proxyLog.isLoggable(Log.BRIEF)) {
                        proxyLog.log(Log.BRIEF, "trying with factory: " + factory);
                    }
                    try (Socket testSocket = factory.createSocket(host, port);){
                        InputStream in = testSocket.getInputStream();
                        int n = in.read();
                    }
                    catch (IOException ex) {
                        if (!proxyLog.isLoggable(Log.BRIEF)) continue;
                        proxyLog.log(Log.BRIEF, "factory failed: ", ex);
                        continue;
                    }
                    proxyLog.log(Log.BRIEF, "factory succeeded");
                    try {
                        fallbackSocket = factory.createSocket(host, port);
                    }
                    catch (IOException ex) {}
                    break;
                }
            }
        }
        Hashtable<String, RMISocketFactory> hashtable = this.successTable;
        // MONITORENTER : hashtable
        try {
            AsyncConnector ex = connector;
            // MONITORENTER : ex
            initialSocket = this.checkConnector(connector);
            // MONITOREXIT : ex
            if (initialSocket != null) {
                if (fallbackSocket != null) {
                    fallbackSocket.close();
                }
                // MONITOREXIT : hashtable
                return initialSocket;
            }
            connector.notUsed();
        }
        catch (NoRouteToHostException | UnknownHostException e) {
            initialFailure = e;
        }
        catch (SocketException e) {
            if (!eagerHttpFallback) throw e;
            initialFailure = e;
        }
        if (fallbackSocket == null) throw initialFailure;
        this.rememberFactory(host, factory);
        // MONITOREXIT : hashtable
        return fallbackSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberFactory(String host, RMISocketFactory factory) {
        Hashtable<String, RMISocketFactory> hashtable = this.successTable;
        synchronized (hashtable) {
            while (this.hostList.size() >= 64) {
                this.successTable.remove(this.hostList.elementAt(0));
                this.hostList.removeElementAt(0);
            }
            this.hostList.addElement(host);
            this.successTable.put(host, factory);
        }
    }

    Socket checkConnector(AsyncConnector connector) throws IOException {
        Exception e = connector.getException();
        if (e != null) {
            e.fillInStackTrace();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new Error("internal error: unexpected checked exception: " + e.toString());
        }
        return connector.getSocket();
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.initialFactory.createServerSocket(port);
    }

    private class AsyncConnector
    implements Runnable {
        private RMISocketFactory factory;
        private String host;
        private int port;
        private AccessControlContext acc;
        private Exception exception = null;
        private Socket socket = null;
        private boolean cleanUp = false;

        AsyncConnector(RMISocketFactory factory, String host, int port, AccessControlContext acc) {
            this.factory = factory;
            this.host = host;
            this.port = port;
            this.acc = acc;
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(host, port);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Socket temp = this.factory.createSocket(this.host, this.port);
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.socket = temp;
                    this.notify();
                }
                RMIMasterSocketFactory.this.rememberFactory(this.host, this.factory);
                asyncConnector = this;
                synchronized (asyncConnector) {
                    if (this.cleanUp) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.exception = e;
                    this.notify();
                }
            }
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }

        synchronized void notUsed() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.cleanUp = true;
        }
    }
}

