/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.HostAddress;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.SeqNumber;

abstract class KrbAppMessage {
    private static boolean DEBUG = Krb5.DEBUG;

    KrbAppMessage() {
    }

    void check(KerberosTime packetTimestamp, Integer packetUsec, Integer packetSeqNumber, HostAddress packetSAddress, HostAddress packetRAddress, SeqNumber seqNumber, HostAddress sAddress, HostAddress rAddress, boolean timestampRequired, boolean seqNumberRequired, PrincipalName packetPrincipal) throws KrbApErrException {
        if (!(sAddress == null || packetSAddress != null && sAddress != null && packetSAddress.equals(sAddress))) {
            if (DEBUG && packetSAddress == null) {
                System.out.println("packetSAddress is null");
            }
            if (DEBUG && sAddress == null) {
                System.out.println("sAddress is null");
            }
            throw new KrbApErrException(38);
        }
        if (!(rAddress == null || packetRAddress != null && rAddress != null && packetRAddress.equals(rAddress))) {
            throw new KrbApErrException(38);
        }
        if (packetTimestamp != null) {
            packetTimestamp.setMicroSeconds(packetUsec);
            if (!packetTimestamp.inClockSkew()) {
                throw new KrbApErrException(37);
            }
        } else if (timestampRequired) {
            throw new KrbApErrException(37);
        }
        if (seqNumber == null && seqNumberRequired) {
            throw new KrbApErrException(400);
        }
        if (packetSeqNumber != null && seqNumber != null) {
            if (packetSeqNumber.intValue() != seqNumber.current()) {
                throw new KrbApErrException(42);
            }
            seqNumber.step();
        } else if (seqNumberRequired) {
            throw new KrbApErrException(42);
        }
        if (packetTimestamp == null && packetSeqNumber == null) {
            throw new KrbApErrException(41);
        }
    }
}

