/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.InvalidKeyException;
import javax.crypto.spec.DESKeySpec;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.CksumType;
import sun.security.krb5.internal.crypto.Des;

public class DesMacCksumType
extends CksumType {
    @Override
    public int confounderSize() {
        return 8;
    }

    @Override
    public int cksumType() {
        return 4;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 16;
    }

    @Override
    public int keyType() {
        return 1;
    }

    @Override
    public int keySize() {
        return 8;
    }

    @Override
    public byte[] calculateChecksum(byte[] data, int size) {
        return null;
    }

    @Override
    public byte[] calculateKeyedChecksum(byte[] data, int size, byte[] key, int usage) throws KrbCryptoException {
        byte[] new_data = new byte[size + this.confounderSize()];
        byte[] conf = Confounder.bytes(this.confounderSize());
        System.arraycopy(conf, 0, new_data, 0, this.confounderSize());
        System.arraycopy(data, 0, new_data, this.confounderSize(), size);
        try {
            if (DESKeySpec.isWeak(key, 0)) {
                key[7] = (byte)(key[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        byte[] residue_ivec = new byte[key.length];
        byte[] residue = Des.des_cksum(residue_ivec, new_data, key);
        byte[] cksum = new byte[this.cksumSize()];
        System.arraycopy(conf, 0, cksum, 0, this.confounderSize());
        System.arraycopy(residue, 0, cksum, this.confounderSize(), this.cksumSize() - this.confounderSize());
        byte[] new_key = new byte[this.keySize()];
        System.arraycopy(key, 0, new_key, 0, key.length);
        for (int i = 0; i < new_key.length; ++i) {
            new_key[i] = (byte)(new_key[i] ^ 0xF0);
        }
        try {
            if (DESKeySpec.isWeak(new_key, 0)) {
                new_key[7] = (byte)(new_key[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException i) {
            // empty catch block
        }
        byte[] ivec = new byte[new_key.length];
        byte[] enc_cksum = new byte[cksum.length];
        Des.cbc_encrypt(cksum, enc_cksum, new_key, ivec, true);
        return enc_cksum;
    }

    @Override
    public boolean verifyKeyedChecksum(byte[] data, int size, byte[] key, byte[] checksum, int usage) throws KrbCryptoException {
        byte[] cksum = this.decryptKeyedChecksum(checksum, key);
        byte[] new_data = new byte[size + this.confounderSize()];
        System.arraycopy(cksum, 0, new_data, 0, this.confounderSize());
        System.arraycopy(data, 0, new_data, this.confounderSize(), size);
        try {
            if (DESKeySpec.isWeak(key, 0)) {
                key[7] = (byte)(key[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        byte[] ivec = new byte[key.length];
        byte[] new_cksum = Des.des_cksum(ivec, new_data, key);
        byte[] orig_cksum = new byte[this.cksumSize() - this.confounderSize()];
        System.arraycopy(cksum, this.confounderSize(), orig_cksum, 0, this.cksumSize() - this.confounderSize());
        return DesMacCksumType.isChecksumEqual(orig_cksum, new_cksum);
    }

    private byte[] decryptKeyedChecksum(byte[] enc_cksum, byte[] key) throws KrbCryptoException {
        byte[] new_key = new byte[this.keySize()];
        System.arraycopy(key, 0, new_key, 0, key.length);
        for (int i = 0; i < new_key.length; ++i) {
            new_key[i] = (byte)(new_key[i] ^ 0xF0);
        }
        try {
            if (DESKeySpec.isWeak(new_key, 0)) {
                new_key[7] = (byte)(new_key[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException i) {
            // empty catch block
        }
        byte[] ivec = new byte[new_key.length];
        byte[] cksum = new byte[enc_cksum.length];
        Des.cbc_encrypt(enc_cksum, cksum, new_key, ivec, false);
        return cksum;
    }
}

