/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class KrbDataInputStream
extends BufferedInputStream {
    private boolean bigEndian = true;

    public void setNativeByteOrder() {
        this.bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    }

    public KrbDataInputStream(InputStream is) {
        super(is);
    }

    public final int readLength4() throws IOException {
        int len = this.read(4);
        if (len < 0) {
            throw new IOException("Invalid encoding");
        }
        return len;
    }

    public int read(int num) throws IOException {
        byte[] bytes = new byte[num];
        if (this.read(bytes, 0, num) != num) {
            throw new IOException("Premature end of stream reached");
        }
        int result = 0;
        for (int i = 0; i < num; ++i) {
            if (this.bigEndian) {
                result |= (bytes[i] & 0xFF) << (num - i - 1) * 8;
                continue;
            }
            result |= (bytes[i] & 0xFF) << i * 8;
        }
        return result;
    }

    public int readVersion() throws IOException {
        int result = (this.read() & 0xFF) << 8;
        return result | this.read() & 0xFF;
    }
}

